package cn.freemud.fuyou.feign.request;

import cn.freemud.fuyou.feign.response.BaseResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author yuanyuan.jing  2018/12/18 19:01
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "查询订单响应-渠道")
@Deprecated
public class QueryResponse extends BaseResult {

    @ApiModelProperty(value = "用户标识", position = 3)
    private String userId;


    @ApiModelProperty(value = "货币类型", position = 4)
    private String transCurrency;


    @ApiModelProperty(value = "总金额", position = 5)
    private Integer totalAmount;


    @ApiModelProperty(value = "商家优惠金额", position = 6)
    private Integer merchantCoupon;

    @ApiModelProperty(value = "平台优惠金额", position = 7)
    private Integer platformCoupon;


    @ApiModelProperty(value = "交易流水号", position = 8)
    private String tradeNo;

    @ApiModelProperty(value = "渠道方", position = 8)
    private String endTransId;


    @ApiModelProperty(value = "第三方交易流水", position = 9)
    private String thirdPartTradeNo;


    @ApiModelProperty(value = "格式：yyyyMMddHHmmss", position = 10)
    private String tradeTime;


    @ApiModelProperty(value = "订单状态", position = 11)
    private TradeState tradeState;

    @ApiModelProperty("第三方商户号")
    private String platformMchId;

    @ApiModelProperty("终端号")
    private String appId;


}
