/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderDiscountReq
 * @Package com.freemud.application.sdk.api.ordercenter.request
 * @Description:
 * @author: ping.wu
 * @date: 2019/5/5 18:05
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.request;

import lombok.Data;

import java.util.List;

@Data
public class OrderDiscountReq {

    //第三方编号
    private String partnerId;

    /**
     * 结算类型 0:其他优惠 1:新用户立减 2:满减 3:抵价券 4:套餐赠送 5:满赠 6:超时赔付 7:部分满减 9:使用红包 10:代金券
     * 11:提前下单立减活动 12:加价购 13:国庆券 14:储值卡 15:会员余额 16:满免配送费 20:单品折扣 23:买赠 46:外卖加价购
     * 118:商品券 200:积分 201:折扣 202:现金 203:微信 204:支付宝 205:优惠总金额 206:单品特价 207:买一送一 208:折扣券
     */
    private List<Integer> settlementTypes;

    //门店编号
    private List<String> storeIds;

    //外部对象ID 如:活动ID
    private List<String> externalObjectIds;

    //订单创建开始时间
    private String startTime;

    //订单创建结束时间
    private String endTime;

    //分页大小
    private Integer pageSize;

    //当前分页
    private Integer pageNum;

}
