package cn.freemud.management.thirdparty;

import cn.freemud.management.entities.dto.request.coupon.MCCafeConponRequest;
import cn.freemud.management.entities.dto.request.coupon.MCCafeCouponLockRequest;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "COUPONMCCafe",url="http://coupon-api-gateway-koderover-dev-coupon.api-ingress.sandload.cn")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CouponOfflineMCCafeClient {

    // 核销优惠券
    @PostMapping("/mccafe/redeem")
    CouponRedeemResponse redeem(MCCafeConponRequest mcCafeConponRequest);

    @PostMapping("/mccafe/cancelRedeem")
    CouponRedeemResponse cancelRedeem(MCCafeConponRequest mcCafeConponRequest);

    @PostMapping("/mccafe/query")
    CouponQueryResponse query(MCCafeConponRequest mcCafeConponRequest);

    // 优惠券锁定
    @PostMapping("/mccafe/lock")
    CouponBaseResponse lock(MCCafeCouponLockRequest MCCafeCouponLockRequest);

    //优惠券解锁
    @PostMapping("/mccafe/unlock")
    CouponBaseResponse unlock(MCCafeCouponLockRequest MCCafeCouponLockRequest);
}
