package com.freemud.application.sdk.api.ordercenter.enums;

public enum PayType {

    ONLINE_PAY(1, "线上支付"),
    CASH_ON_DELIVERY(2, "货到付款");

    private Integer code;
    private String desc;

    PayType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static PayType getByCode(Integer code) {
        for (PayType payType : values()) {
            if (payType.getCode().equals(code)) {
                return payType;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
