package com.freemud.application.sdk.api.ordercenter.entities.v1;

import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class ProductBeanV1 {

    /**
     * customerCode :
     * number : 1
     * opid : 0
     * orderId : 109457845547698183
     * parentProduct :
     * picture :
     * price : 1100
     * productId : product1
     * productName : 奶茶
     * sequence : 10
     * specification : 中杯+常温
     * specificationName :
     * unit :
     */
    /**
     * 重量
     */
    private BigDecimal weight;
    /**
     * 优惠分摊金额
     */
    private BigDecimal productSharePrice;
    private String customerCode;
    /**
     * 商品货号，商品服务可重复
     */
    private String productCode;
    /**
     * 商品数量
     */
    private int number;
    private String opid;
    /**
     * 订单ID
     */
    private String orderId;
    /**
     * 商品ID
     */
    private String productId;
    /**
     * 父类商品ID
     */
    private String parentProductId;
    /**
     * 商品图片
     */
    private String picture;
    /**
     * 商品价格
     */
    private Long price;
    /**
     * 商品实际销售价格 扣除优惠价格后计算salePrice V1.5.2增加
     */
    private Long salePrice;
    //均摊价格
    private Long settlementPrice;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品英文名称
     */
    private String productForeignName;
    /**
     * 商品排序
     */
    private int sequence;
    /**
     * 商品描述
     */
    private String specification;
    private String specificationName;
    private String specificationForeignName;
    private String unit;
    /**
     * 商品扩展字段 保存为
     */
    private String addInfo;

    private String foreignAddInfo;

    /**
     * 商品属性
     */
    private String productProperty;
    private String productForeignProperty;

    /**
     * 数据库字段（保存套餐商品是否为固定商品）
     */
    private String extInfo;

    /**
     * 备注
     */
    private String note;

    /**
     * 商品type
     */
    private Integer productType;

    /**
     * 当前商品的实际优惠信息
     */
    public List<ProductDiscountV1> discountList;
    /**
     * 订单商品明细ID，由订单服务生成
     */
    private Long id;

    /**
     * 加购人ID
     */
    private String userId;

    /**
     * 加购人openId
     */
    private String openId;

    /**
     * 加购人昵称
     */
    private String nickName;

    /**
     * 加购人头像
     */
    private String photoUrl;

    /**
     * 加购人包装费
     */
    private Long packPrice;

    /**
     * 套餐子商品
     */
    public List<ProductBeanV1> comboProduct;

    /**
     * 套餐子商品
     */
    public List<ProductBeanV1> materialProduct;

    /**
     * 赠品
     */
    public List<ProductBeanV1> sendProduct;

    /**
     * 商品拓展字段extInfo转换对象接收
     */
    public List<ProductExtInfoV1> productExtInfo;

    /**
     * 购物车行uid
     */
    private String cartGoodsUid;

    /**
     * 拼单买一赠一标记赠品是那个商品送的 originalGoodsUid
     */
    private String originalGoodsUid;

    /**
     * 是否打印
     */
    private Boolean isPrint;

    /**
     * 是否是赠品
     */
    private Boolean isSendGoods;

}
