package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

@Data
public class ActivityCancelStockRequestDto {
    /**
     * 版本号
     */
    private String ver;
    /**
     * 商户号
     */
    private String partnerCode;

    /**
     * 订单号
     */
    private String orderId;
    /**
     * 交易类型 1-活动冲正 2-优惠券冲正 3-商品冲正
     */
    private List<Integer> transType;

    /**
     * 门店ID
     */
    private String storeId;

    /**
     * 用户ID
     */
    private String userId;
    /**
     * 券code
     */
    private String couponCode;

    private List<ProductVo> products;

    private List<CouponCodeVerificationProductDto> couponProducts;

    @Data
    public static class ProductVo {
        private String skuId;

        private int qty;
    }

}
