/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CommonConstants
 * @Package cn.freemud.constant
 * @Description: redisKey相关的常量
 * @author: 布丁
 * @date: 2021/07/02
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.constant;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Getter
public class ConfigConstants {

    @Value("${print-debug-log:false}")
    private boolean printDebug;
    /**
     * 紧急方案 涉及配置:开关 true=打开,默认是false
     */
    @Value("${order.callback.urgent.plan.open:false}")
    private boolean urgentCallbackOpen;
    /**
     * 紧急方案 涉及配置:锁定分钟
     */
    @Value("${order.callback.urgent.plan.open.lock.minutes:30}")
    private long urgentCallbackLockMinutes;
    /**
     * 紧急方案 涉及配置:锁定涉及订单状态列表
     * 2=下单(支付成功);3=接单;
     */
    @Value("${order.callback.urgent.plan.open.status:2,3}")
    private List<Integer> urgentStatus;
}
