/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class UpdateShoppingCartGoodsQtyRequestVo extends BaseRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    private String sessionId;

    @NotEmpty(message = "appId不能为空")
    private String appId;
    /**
     * 购物车一行的ID
     */
    @NotEmpty(message = "cartGoodsUid不能为空")
    private String cartGoodsUid;

    /**
     * 商品数量
     */
    @NotNull(message = "qty不能为空")
    private Integer qty;

    private String version;
    /**
     * 购物车版本号（围餐）
     */
    private Integer carVer;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    private Integer businessType ;

}
