package cn.freemud.service.impl

import cn.freemud.adapter.OrderAdapter
import cn.freemud.entities.bo.CreateOrderBONew
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto
import cn.freemud.entities.dto.store.StoreMixResponseDto
import cn.freemud.entities.vo.CreateOrderVo
import cn.freemud.service.business.impl.OrderBusinessServiceImpl
import com.alibaba.fastjson.JSON
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo
import com.freemud.application.sdk.api.ordercenter.request.OrderExtInfoDto
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter
import spock.lang.Specification

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2022/2/23 17:17
 * @description : 
 */
class OrderAdapterServiceImplTest extends Specification {

    def orderServiceImpl = new OrderServiceImpl()

    def orderAdapter = new OrderAdapter(mcCafePartnerId: ["9999"], cocoPartnerId: ["9999"])

    def itemService = Mock(ItemServiceImpl.class)

    def orderBusinessService = new OrderBusinessServiceImpl()

    def orderSdkAdapter = new OrderSdkAdapter()

    void setup() {
        orderServiceImpl.orderAdapter = orderAdapter
        orderServiceImpl.itemService = itemService
        orderBusinessService.orderSdkAdapter = orderSdkAdapter
        orderServiceImpl.orderBusinessService = orderBusinessService

    }

    def "测试华莱士订单问题"() {
        given: "参数设置"
        def createOrderBO = new CreateOrderBONew()
        // 接口请求信息
        String createVOStr = "{\"buyType\":0,\"channel\":\"1\",\"channelType\":\"saas\",\"couponCode\":\"88709227085491207040\",\"couponCodes\":[{\"couponCode\":\"88709227085491207040\",\"couponType\":7}],\"expectTime\":\"\",\"latitude\":\"31.293401421440972\",\"longitude\":\"121.30461995442708\",\"menuType\":\"saas\",\"mobile\":\"17327190802\",\"orderRemark\":\"测试单，请勿制作出餐，谢谢！\",\"orderType\":1,\"partnerId\":\"2581\",\"payChannelType\":1,\"reachStoreType\":5,\"sessionId\":\"cef46527f632a961af7a84209bdb8fcd0997c936\",\"sessionKey\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"shopId\":\"229830\",\"storeAddress\":\"河南省驻马店市西平县经贸路步行街西段小广场华莱士\",\"storeName\":\"华莱士（西平步行街店）\",\"storeNameEn\":\"\",\"tableNumber\":\"\",\"takeMealFlag\":\"0\",\"takeMealTime\":\"\",\"thirdShopId\":\"EA23\",\"useCustomerScore\":2,\"userId\":\"3614319825989629832\",\"userName\":\"SWEET SUGA\",\"version\":\"2.0.60.6\"}";
        def createOrderVo = JSON.parseObject(createVOStr, CreateOrderVo.class)
        createOrderBO.setCreateOrderVo(createOrderVo)
        // 登录信息
        def userLoginInfoDto = JSON.parseObject("{\"accessToken\":\"\",\"alipayUserId\":\"\",\"appId\":\"wx3f7ca0c75b213380\",\"appSecret\":\"\",\"appsecret\":\"\",\"channel\":\"1\",\"customerId\":\"\",\"devBrand\":\"\",\"devModel\":\"\",\"iappId\":\"7\",\"memberId\":\"3614319825989629832\",\"mobile\":\"17327190802\",\"newMember\":false,\"nickName\":\"SWEET SUGA\",\"openId\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"openid\":\"o98fP4qjUo7xm-nT-JAaVEk9yBqM\",\"partnerId\":\"2581\",\"photoUrl\":\"https://thirdwx.qlogo.cn/mmopen/vi_32/zahIlicTNSM0IA0qjOryv6s0SzIhlwW9EpQKvL63GbPhBwficMAibDohDEibSCQU0I5KohibIpp0yL57TWRcVKrRH2A/132\",\"registerTime\":\"2021-02-26 14:10:26\",\"sessionId\":\"cef46527f632a961af7a84209bdb8fcd0997c936\",\"sessionKey\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"session_key\":\"hZtQ1Usx/NhEUyoyduF+FQ==\",\"storeId\":\"\",\"tableNumber\":\"\",\"thirdPartyMemberID\":\"\",\"thirdPartyPartnerID\":\"\",\"unionId\":\"o7cEm68JPFhbrzqb0a0BcQE-dDVA\",\"wxAppId\":\"wx3f7ca0c75b213380\",\"wxAppid\":\"wx3f7ca0c75b213380\"}"
                , AssortmentCustomerInfoVo.class)
        createOrderBO.setUserLoginInfoDto(userLoginInfoDto)
        //  购物车信息
        def shoppingCartGoodsDto = JSON.parseObject("{\"activityDiscountsDtos\":[{\"activityCode\":\"88709227085491207040\",\"activityName\":\"鸡米花买一送一券\",\"activityType\":32,\"discountAmount\":-800,\"priority\":0}],\"isDiscountDelivery\":false,\"originalTotalAmount\":2400,\"products\":[{\"activityDiscountsDtos\":[{\"activityCode\":\"88709227085491207040\",\"activityName\":\"鸡米花买一送一券\",\"activityType\":32,\"actualActivityGoodsNumber\":1,\"cartGoodsUid\":\"09b125d6-603d-4783-ba01-287073d08e2b\",\"discountAmount\":800}],\"cartGoodsUid\":\"09b125d6-603d-4783-ba01-287073d08e2b\",\"couponCode\":\"88709227085491207040\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isSendGoods\":false,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":800,\"originalProductType\":1,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1619081297921.jpg\",\"qty\":2,\"salePrice\":800,\"skuId\":\"201889966261817090\",\"skuName\":\"鸡米花T\",\"spuId\":\"201889966261817090\",\"spuName\":\"鸡米花T\",\"stockLimit\":false,\"totalDiscountAmount\":-800,\"unit\":\"\",\"weight\":0.0},{\"activityDiscountsDtos\":[],\"cartGoodsUid\":\"02537906-b09d-4a76-b5b7-2a5842a31a6c\",\"categoryName\":\"缤纷小食\",\"classificationId\":\"0102\",\"classificationName\":\"正价单品\",\"customerCode\":\"hn80017\",\"extraList\":[],\"hasProductCoupon\":false,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isSendGoods\":false,\"isTableware\":0,\"linkedId\":\"\",\"materialList\":[],\"originalPrice\":800,\"originalProductType\":1,\"packPrice\":0,\"picture\":\"https://picture.sandload.cn/1619080995048.jpg\",\"productCode\":\"hn80017\",\"qty\":1,\"salePrice\":800,\"skuForeignName\":\"\",\"skuId\":\"201889966070976307\",\"skuName\":\"薯条(大)T\",\"spuForeignName\":\"\",\"spuId\":\"201889966070976307\",\"spuName\":\"薯条(大)T\",\"stockLimit\":false,\"tax\":0.01,\"taxId\":\"\",\"totalDiscountAmount\":0,\"unit\":\"\",\"weight\":0.0}],\"reduceScore\":0,\"scoreReduceAmount\":0,\"shareDiscountActivityDtos\":[],\"totalAmount\":1600,\"totalDiscountAmount\":800,\"totalScore\":0}"
                , ShoppingCartGoodsDto.class)
        createOrderBO.setShoppingCartGoodsDto(shoppingCartGoodsDto)

        //拓展信息
        def extInfo = new OrderExtInfoDto()
        createOrderBO.setExtInfo(extInfo)

        // 门店信息
        def storeMixResponseDto = JSON.parseObject("{\n" +
                "        \"storeInfo\": {\n" +
                "            \"storeId\": \"32f47616-6e78-42c3-b5ee-768d9983fc69\",\n" +
                "            \"storeCode\": \"229830\",\n" +
                "            \"storeName\": \"华莱士（西平步行街店）\",\n" +
                "            \"storeNameEn\": null,\n" +
                "            \"parentId\": \"16dc665e-8e03-41a8-83ae-95e92666d266\",\n" +
                "            \"parentCode\": \"05Y\",\n" +
                "            \"parentName\": \"湖北（豫）\",\n" +
                "            \"partnerId\": \"2581\",\n" +
                "            \"briefName\": null,\n" +
                "            \"longitude\": \"114.02106387473609\",\n" +
                "            \"latitude\": \"33.383438776512136\",\n" +
                "            \"geohash\": \"wtcjft\",\n" +
                "            \"businessHours\": \"00:00-24:00\",\n" +
                "            \"state\": \"1\",\n" +
                "            \"phone\": \"17719196597\",\n" +
                "            \"address\": \"河南省驻马店市西平县经贸路步行街西段小广场华莱士\",\n" +
                "            \"addressEn\": null,\n" +
                "            \"activeFlag\": 1,\n" +
                "            \"remark\": null,\n" +
                "            \"province\": \"河南省\",\n" +
                "            \"city\": \"驻马店市\",\n" +
                "            \"region\": \"西平县\",\n" +
                "            \"delivery\": \"2\",\n" +
                "            \"deliveryHours\": \"\",\n" +
                "            \"freeDeliveryPrice\": 20.0,\n" +
                "            \"distributionScope\": \"\",\n" +
                "            \"businessHoursDay\": \"00:00-24:00\",\n" +
                "            \"deliveryHoursDay\": null,\n" +
                "            \"storeNotice\": null,\n" +
                "            \"logoUrl\": null,\n" +
                "            \"isBusinessOpen\": \"1\",\n" +
                "            \"businessType\": \"1\",\n" +
                "            \"isSelfMention\": 1,\n" +
                "            \"showDiscount\": null,\n" +
                "            \"thirdPartCode\": \"EA23\",\n" +
                "            \"status\": 1,\n" +
                "            \"deliveryRemark\": null\n" +
                "        },\n" +
                "        \"deliveryInfo\": null,\n" +
                "        \"businessInfo\": {\n" +
                "            \"id\": 203735268043408939,\n" +
                "            \"templateName\": \"【河南】无外卖 无预定单\",\n" +
                "            \"templateType\": 1,\n" +
                "            \"partnerId\": \"2581\",\n" +
                "            \"orderWarnTime\": \"1\",\n" +
                "            \"deliveryOrderWarnTime\": \"1\",\n" +
                "            \"orderPrintConfig\": \"2\",\n" +
                "            \"maxOrderQuantity\": 10000,\n" +
                "            \"isAutoTakeOrder\": 1,\n" +
                "            \"pickupAutomaticOrderTime\": 1,\n" +
                "            \"takeoutAutomaticOrderTime\": 1,\n" +
                "            \"autoChargebackOrderType\": 1,\n" +
                "            \"autoChargebackOrderTime\": 1,\n" +
                "            \"overTimeCloseOrder\": 1,\n" +
                "            \"overTimeCloseOrderTime\": 30,\n" +
                "            \"autoSelfmentionTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"autoSelfmentionMakerWorkflowFinishTime\": 4,\n" +
                "            \"autoTakeOutTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"autoDeliveryTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"appointAutoSelfmentionTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoSelfmentionMakerWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoTakeOutTakeOrderWorkflowFinishTime\": 4,\n" +
                "            \"appointAutoDeliveryTakeOrderWorkflowFinishTime\": 3,\n" +
                "            \"autoThirdDeliveryTakeOrderWorkflowFinishTime\": 5,\n" +
                "            \"appointThirdDeliveryTakeOrderWorkflowFinishTime\": 6,\n" +
                "            \"orderType\": \"pickup\",\n" +
                "            \"invoice\": 0,\n" +
                "            \"deliveryHours\": \"\",\n" +
                "            \"expectedTime\": 0,\n" +
                "            \"takePartInSettleAccounts\": 2,\n" +
                "            \"automaticRefund\": 1,\n" +
                "            \"minPriceForInvoice\": 0,\n" +
                "            \"invoiceExplain\": \"\",\n" +
                "            \"deliveryAppoint\": 0,\n" +
                "            \"deliveryAppointTime\": null,\n" +
                "            \"tableware\": 0,\n" +
                "            \"selfMentionSwitch\": 0,\n" +
                "            \"autoThirdDeliveryPickCompleteWorkflowFinishTime\": 5,\n" +
                "            \"appointThirdDeliveryPickCompleteWorkflowFinishTime\": 5,\n" +
                "            \"timeOfRefund\": \"48\",\n" +
                "            \"timeTypeOfRefund\": 2,\n" +
                "            \"turnOnTimeOfMaking\": 2,\n" +
                "            \"goodsAvgTimeOfMaking\": 5,\n" +
                "            \"deliveryFinishedAfterMinute\": 45,\n" +
                "            \"deliveryProcessingAfterMinute\": 30,\n" +
                "            \"deliveryProcessingBeforeMinute\": 30,\n" +
                "            \"orderProgressBarStatus\": 2,\n" +
                "            \"expandFields\": {\n" +
                "                \"dispatchType\": \"0\",\n" +
                "                \"monthlySalesShow\": \"0\",\n" +
                "                \"progressBarStatus\": 2,\n" +
                "                \"progressBarOrderNumber\": 0,\n" +
                "                \"preOrderSwitch\": \"0\",\n" +
                "                \"pickupPackageFeeSwitch\": \"1\",\n" +
                "                \"dispatchConfig\": [],\n" +
                "                \"deliveryPackageFeeSwitch\": \"1\",\n" +
                "                \"monthlySalesConfigValue\": \"0\",\n" +
                "                \"likesShow\": \"0\",\n" +
                "                \"likesConfigValue\": \"0\",\n" +
                "                \"processBarColorList\": \"\",\n" +
                "                \"scanOrderSwitch\": \"0\",\n" +
                "                \"progressBarProductUnit\": 1,\n" +
                "                \"peakTimeDelivery\": [],\n" +
                "                \"progressBarDetailStatus\": 1,\n" +
                "                \"appendMinutePerKilometer\": \"0\",\n" +
                "                \"progressBarPageList\": \"\"\n" +
                "            },\n" +
                "            \"orgIds\": null,\n" +
                "            \"supportCashierPay\": 2,\n" +
                "            \"processBarResponse\": null\n" +
                "        },\n" +
                "        \"parentUntilTop\": null,\n" +
                "        \"storeImageList\": null,\n" +
                "        \"storeBusyTimeInfoList\": null\n" +
                "    }"
                , StoreMixResponseDto.class)
        createOrderBO.setStoreMixResponseDto(storeMixResponseDto)

        when: "调用方法"
        def order = orderServiceImpl.sdkCreateOrder(createOrderBO)

        then: "验证"

    }

}
