package cn.freemud.entities.dto.store;

import lombok.Data;

import java.util.List;

@Data
public class BusinessInfoDto {

    private Long id;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板类型0:通用 1:个性化
     */
    private Integer templateType;

    /**
     * 所属商户
     */
    private String partnerId;

    /**
     * 预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟;5:5分钟;6:10分钟}
     */
    private String orderWarnTime;

    /**
     * 外卖预订单提醒时间{1:15分钟;2:30分钟;3:45分钟;4:60分钟;5:5分钟;6:10分钟}
     */
    private String deliveryOrderWarnTime;

    /**
     * 预订单打印时间{1：提醒时打印；2：接单时打印}
     */
    private String orderPrintConfig;

    /**
     * 最大接单量,单位笔
     */
    private Integer maxOrderQuantity;

    /**
     * 是否支持自动接单(1是2否)
     */
    private Integer isAutoTakeOrder;

    /**
     * 自提-服务端自动接单时间 1:立即;2:1分钟;3:5分钟（顾客下单XX后，订单状态自动更改为已接单）
     */
    private Integer pickupAutomaticOrderTime;

    /**
     * 外卖-服务端自动接单时间 1:立即;2:1分钟;3:5分钟（顾客下单XX后，订单状态自动更改为已接单）
     */
    private Integer takeoutAutomaticOrderTime;

    /**
     * 退单模式 1手动退单 2自动退单
     */
    private Integer autoChargebackOrderType;
    /**
     * 自动退单时间
     */
    private Integer autoChargebackOrderTime;
    /**
     * 超时关单 1开启 2关闭
     */
    private Integer overTimeCloseOrder;

    /**
     * 接单超时关单时间，默认30分钟
     */
    private Integer overTimeCloseOrderTime;

    /**
     * 自提单接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoSelfmentionTakeOrderWorkflowFinishTime;

    /**
     * 自提单制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoSelfmentionMakerWorkflowFinishTime;

    /**
     * 自建外卖接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoTakeOutTakeOrderWorkflowFinishTime;

    /**
     * 自建外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer autoDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 预约自提单接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoSelfmentionTakeOrderWorkflowFinishTime;

    /**
     * 预约自提单制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoSelfmentionMakerWorkflowFinishTime;

    /**
     * 预约自建外卖接单后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoTakeOutTakeOrderWorkflowFinishTime;

    /**
     * 预约自建外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;
     */
    private Integer appointAutoDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 实时三方外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer autoThirdDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 预约三方外卖制作完成后自动流程时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer appointThirdDeliveryTakeOrderWorkflowFinishTime;

    /**
     * 点餐方式(,隔开)：pickup,delivery
     */
    private String orderType;

    /**
     * 是否支持发票 1是 0否
     */
    private Integer invoice;

    /**
     * 外卖时间：00:00-23:59
     */
    private String deliveryHours;
    /**
     * 预计送达时间（分钟）
     */
    private Integer expectedTime;

    /**
     * 参与结算（1：是、2：否）
     */
    private Integer takePartInSettleAccounts;

    /**
     * 是否自动同意退款（同意:1,不同意:0）
     */
    private Integer automaticRefund;

    /**
     * 可开票的最小价格
     */
    private Integer minPriceForInvoice;

    /**
     * 发票特殊说明
     */
    private String invoiceExplain;

    /**
     * 外卖预约单开关（0:关闭，1:开启）
     */
    private Integer deliveryAppoint;

    /**
     * "外卖预约单时间（分钟） 65分钟、90分钟、120分钟"
     */
    private Integer deliveryAppointTime;
    /**
     * 是否需要餐具 1 需要 0 不需要
     */
    private Integer tableware;

    /**
     * 自提预约单开关（0:关闭，1:开启）
     */
    private Integer selfMentionSwitch;

    /**
     * 三方外卖订单自动拣货完成时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟
     */
    private Integer autoThirdDeliveryPickCompleteWorkflowFinishTime;

    /**
     * 三方外卖预订单自动拣货完成时间 1:2小时;2:1小时;3:30分钟;4:15分钟;5:10分钟;6:5分钟;7:3分钟;8:2分钟;
     */
    private Integer appointThirdDeliveryPickCompleteWorkflowFinishTime;

    private String timeOfRefund;

    private Integer timeTypeOfRefund;


    /**
     * 开启制作时间 1 ：是 ， 2 ：否
     */
    private Integer turnOnTimeOfMaking;

    /**
     * 商品平均制作时常 分钟
     */
    private Integer goodsAvgTimeOfMaking;

    /**
     * 自建外卖订单，商家自配送xx分钟后，订单状态更改为【已完成】
     */
    private Integer deliveryFinishedAfterMinute;

    /**
     * 自建外卖订单-实时单，商家自配送，门店接单xx分钟后，订单状态变更为配送中
     */
    private Integer deliveryProcessingAfterMinute;

    /**
     * 自建外卖订单-预约单，商家自配送，预约商家前xx分钟，订单更改为配送中
     */
    private Integer deliveryProcessingBeforeMinute;
    /**
     * 点餐进度条 1 开启，2 关闭
     */
    private Integer orderProgressBarStatus;

    /**
     * 收银买单开关 1 开启 2 关闭
     */
    private Integer supportCashierPay;

    /**
     * 拓展字段定义
     */
    private ExpandInfo expandFields;


    @Data
    public static class ExpandInfo {
        /**
         * 月销量是否展示（1-是；0-否）
         */
        private Integer monthlySalesShow;

        /**
         * 月销量配置值
         */
        private Integer monthlySalesConfigValue;

        /**
         * 点赞数是否展示（1-是；0-否）
         */
        private Integer likesShow;

        /**
         * 点赞数配置值
         */
        private Integer likesConfigValue;

        /**
         * 高峰时间配送时间
         */
        private List<PeakTimeDelivery> peakTimeDelivery;

        /**
         * 每增加一公里增加的时长（分钟）
         */
        private Integer appendMinutePerKilometer;

        @Data
        public static class PeakTimeDelivery {
            /**
             * 高峰期开始时间
             */
            private String startTime;
            /**
             * 高峰期结束时间
             */
            private String endTime;
            /**
             * 耗费时间
             */
            private Integer costMinute;
        }

        /**
         * 扫桌码下单(1-开启;0-关闭)
         */
        private Integer scanOrderSwitch;

        /**
         * 爱马哥蛋糕预定单开关(1-开启;0-关闭)
         */
        private Integer preOrderSwitch;
    }

}
