package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.enums.OrderType;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import lombok.Data;

import java.util.List;

@Data
public class BaseQueryOrderRequest extends BaseConfig {

    private String partnerId;

    private String orderId;

    private List<String> orderIds;
    /**
     * 下单渠道（1:自营微信小程序 2:SAAS,i应用 3:自营支付宝小程序 4:自营H5 5:自营安卓APP 6:自营苹果APP 7:自营PC-WEB 8:饿了么 9:饿百 10:京东 11:美团外卖 12:自营APP 13:i应用会员 14:i应用订货 15:POS）
     */
    private String orderClient;
    /**
     * 第三方订单号
     */
    private String thirdOrderCode;

    private String userId;

    private String shopId;

    private OrderType orderType;

    private Integer timeout;

    /**
     * 前置处理 timeout时间, 因为后面的代码调用sdk很多地方不兼容,
     */
    private Integer preTimeout;
    /**
     * 售后单code 新订单服务需要
     */
    private String afterSalesCode;
    /**
     * 退款流水号
     */
    private String refundSerialNo;

    //同意退款原因
    private String reason;

    /**
     * true:自配送   false:第三方配送
     * 接单和送出接口使用
     */
    private boolean hasSelfDelivery;

    /**
     * 是否返回订单操作记录 0=否  1=是
     */
    private Integer withOperationHistory;

    //操作人
    private String operator;

    //用户预约时间，仅为预约单时存放
    private String expectTime;
    //外卖单配送类型
    private String deliveryType;

    // 合阔pos 商户订单状态不自动扭转
    private Boolean notAutomaticTwist;


    /**
     * 派单模式(0-系统自动派单;1-手动派单)
     * 内置传参使用
     */
    private String dispatchType;
    /**
     * 半自动派单时间 (分钟)
     */
    private Integer dispatchTimeout;
}
