/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMemberCouponListRequestDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: song.cai
 * @date: 2018/12/24 16:49
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NonNull;

import java.math.BigDecimal;
import java.util.List;

@Data
public class GetMemberCouponListResponseDto {
    @NonNull
    private String code;
    @NonNull
    private String message;

    private Integer ver;
    private Result data;

    @Data
    public final static class Result {
        /**
         * 总页数
         */
        private Integer totalPages;
        /**
         * 当前页
         */
        private Integer pageNum;
        /**
         * 每页条目数
         */
        private Integer pageSize;
        /**
         * 总数
         */
        private Integer totalCount;
        /**
         * 优惠券列表
         */
        private List<MemberCoupon> memberCoupons;

        @Data
        public final static class MemberCoupon {
            /**
             * 优惠券号
             */
            private String couponCode;
            /**
             * 活动号
             */
            private String activityCode;
            /**
             * 促销活动号
             */
            private String promotionCode;
            /**
             * 优惠券名称
             */
            private String couponName;
            /**
             * 生效开始时间(yyyy-MM-dd HH:mm:ss)
             */
            private String startTime;
            /**
             * 生效结束时间(yyyy-MM-dd HH:mm:ss)
             */
            private String endTime;
            /**
             * 优惠券使用说明
             */
            private String remark;

            /**
             * 券类型:
             * 0:商品券;1:代金券;2:折扣券
             */
            private Integer couponType;
            /**
             * 发码时间
             */
            private String createTime;
            /**
             * 核销时间
             */
            private String redeemTime;
            /**
             * 状态
             */
            private Integer status;
            /**
             * 微信卡包ID
             */
            private String cardId;
            /**
             * 是否导入微信卡包 1：未同步（默认）,2：已同步
             */
            private Integer isSynWechat;
            /**
             * 活动描述(通过查询券活动获取)
             */
            private String activeDesc;
            /**
             * 起用金额 最低使用金额（分）(满多少可用)
             */
            private Long minAmount;
            /**
             * 原价(代金券优惠金额，单位分)( 满多少享受多少优优惠)
             */
            private Long originalPrice;
            /**
             * 折扣百分比（例如：八折-- 80）(满多少享受多少优优惠)
             */
            private BigDecimal percentDiscount;
            /**
             * 商品信息(商品id)
             */
            private List<String> activeProducts;
        }
    }

}
