package cn.freemud.service.impl;

import cn.freemud.adapter.ActivityAdapter;
import cn.freemud.adapter.ShoppingCartConvertAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ShoppingCartConstant;
import cn.freemud.entities.dto.ActivityCalculationDiscountRequestDto;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.UserLoginInfoDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.dto.user.GetSessionUserInfoDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.factory.AbstractShoppingCartImpl;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.ShoppingCartNewService;
import cn.freemud.service.thirdparty.CustomerApplicationClient;
import cn.freemud.utils.RedisLock;
import cn.freemud.utils.ResponseUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.productcenter.domain.ProductBeanDTO;
import com.freemud.application.sdk.api.promotioncenter.dto.promotion.DiscountDTO;
import com.freemud.card.sdk.log.ErrorLog;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CartResponseConstant;
import com.freemud.sdk.api.assortment.shoppingcart.constant.CommonsConstant;
import com.freemud.sdk.api.assortment.shoppingcart.constant.RedisKeyConstant;
import com.freemud.sdk.api.assortment.shoppingcart.request.CheckCartRequest;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.CollageCartBaseServiceImpl;
import com.freemud.sdk.api.assortment.shoppingcart.service.impl.ShoppingCartBaseServiceImpl;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.MessageFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: null.java
 * @Package
 * @Description: (用一句话描述该文件做什么)
 * @author: pegnfei.liu
 * @date: 2020-9-24
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */

@Service
public class ShoppingCartCollageServiceImpl extends AbstractShoppingCartImpl implements ShoppingCartNewService {

    @Autowired
    private AssortmentSdkService assortmentSdkService;

    @Autowired
    private CollageCartBaseServiceImpl collageCartBaseService;

    @Autowired
    private ShoppingCartBaseServiceImpl shoppingCartBaseService;

    @Autowired
    private ActivityAdapter activityAdapter;

    @Autowired
    private RedisCache redisCache;

    @Override
    public BaseResponse addGoodsByCard(AddGoodsByWeixinCardRequestVo request) {
        return null;
    }

    @Override
    public BaseResponse addGoods(AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo) {

        ShoppingCartConvertAdapter.convent2SkuId(addShoppingCartGoodsRequestVo);
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();

        // 获取当前登陆用户信息
        CustomerInfoVo currentUserInfoVo = getCustomerInfoVo(addShoppingCartGoodsRequestVo.getSessionId());
        // 当前用户必须登陆
        if (currentUserInfoVo.getMemberId() == null) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        UserLoginInfoDto userLoginInfoDto = convert2UserLoginInfoDto(currentUserInfoVo);

        String currentUserId = currentUserInfoVo.getMemberId();
        String partnerId = addShoppingCartGoodsRequestVo.getPartnerId();
        String storeId = addShoppingCartGoodsRequestVo.getShopId();
        String appId = addShoppingCartGoodsRequestVo.getAppId();
        String spuId = addShoppingCartGoodsRequestVo.getSpuId();
        String skuId = addShoppingCartGoodsRequestVo.getSkuId();
        String goodsId = StringUtils.isEmpty(skuId) ? spuId : skuId;
        String menuType = addShoppingCartGoodsRequestVo.getMenuType();
        Integer orderType = addShoppingCartGoodsRequestVo.getOrderType();
        String receiveId = addShoppingCartGoodsRequestVo.getReceiveId();
        // 获取拼单发起人id
        String crateUserId = addShoppingCartGoodsRequestVo.getCreateCollageUserId();

        // 拼单相关条件校验
        check(partnerId, storeId, crateUserId,addShoppingCartGoodsRequestVo);

        CartGoods cartGoods = ShoppingCartConvertAdapter.convent2CartGoods(addShoppingCartGoodsRequestVo);
        cartGoods.setSessionId(addShoppingCartGoodsRequestVo.getSessionId());
        cartGoods.setUserId(currentUserId);

        List<Long> productIds = new ArrayList<>();
        productIds.add(Long.parseLong(goodsId));

        // 获取商品详细信息
        List<ProductBeanDTO> productBeanListSpuClass = assortmentSdkService.getProductsInfoSdk(partnerId, storeId, Collections.singletonList(spuId),addShoppingCartGoodsRequestVo.getMenuType(), this.shoppingCartBaseService);

        // 购物车版本加锁
        dolock(partnerId, storeId, crateUserId,addShoppingCartGoodsRequestVo);
        List<CartGoods> allCartGoodsList = null;
        String productName = null;

        try {
            //缓存中获取购物车商品信息
            allCartGoodsList = assortmentSdkService.getShoppingCart(partnerId, storeId, crateUserId, addShoppingCartGoodsRequestVo.getSessionId(), null, collageCartBaseService);
            if (CollectionUtils.isEmpty(allCartGoodsList)) {
                allCartGoodsList = new ArrayList<>();
            }

            Integer sumSkuQty = this.sumSkuQty(allCartGoodsList, cartGoods);
            //查询多个商品库存信息
            this.queryManyGoodsStocks(addShoppingCartGoodsRequestVo, productIds, productBeanListSpuClass, skuId, sumSkuQty);
            productName = null;

            //添加非商品券商品
            List<CartGoods> cartGoodsRedisList= addNotProductCouponGoods(addShoppingCartGoodsRequestVo, cartGoods, goodsId, crateUserId, shoppingCartGoodsResponseVo, allCartGoodsList);

            // 更新拼单购物车人员缓存中的的购物车行id集合
            List<String> cartGoodsUids = cartGoodsRedisList.stream().map(CartGoods::getCartGoodsUid).collect(Collectors.toList());
            collageCartBaseService.updateCollageCartGoodsUids(cartGoodsUids,partnerId, storeId, crateUserId,addShoppingCartGoodsRequestVo.getSessionId());

            // 当商品数量被设为0时
            if (Objects.equals(cartGoods.getQty(), 0)) {
                assortmentSdkService.updateGoodsQtyBySdk(partnerId, currentUserId, storeId, cartGoods.getCartGoodsUid(), 0, "", shoppingCartBaseService);
            }

        } catch (Exception e) {
            ErrorLog.errorConvertJson(SDKCommonBaseContextWare.getAppName(), LogThreadLocal.getTrackingNo(), getClass(), "updateGoodsQty:" + e.getMessage(), e);
            return ResponseUtil.error(ResponseResult.SHOPPING_CART_VERSION_ERROR, "购物车商品有变动，请手动刷新再修改");
        }finally {
            // 购物车版本解锁
            // 版本锁的粒度控制在获取购物车、刷新购物车、刷新车人员缓存行
            // 当这些操作结束后，购物的更新操作，已经结束，其他的流程是针对已经添加到redis中的购物车做查询操作
            // 所以只有上述的流程才加锁控制
            doUnlock(partnerId, storeId, crateUserId);
        }

        // 配送费
        Long deliveryAmount = calculateDeliveryAmount(receiveId, partnerId, storeId, userLoginInfoDto.getWxAppid(), shoppingCartGoodsResponseVo);

        // 获取优惠信息
        ActivityCalculationDiscountResponseDto.CalculationDiscountResult calculationDiscountResult
                =getCalculationDiscountResult(menuType,partnerId,storeId,currentUserId,appId,userLoginInfoDto.getWxAppid(),orderType,currentUserInfoVo.isMemberPaid(), allCartGoodsList,new ArrayList(),new ArrayList<>(),null,deliveryAmount);

        ActivityQueryDto activityQueryDto = activityAdapter.getActivityQueryDto(partnerId, storeId, currentUserId, appId, addShoppingCartGoodsRequestVo.getOrderType());

        // 促销活动的优惠金额计算
        updateShoppingCartGoodsDiscount(null, activityQueryDto, calculationDiscountResult, allCartGoodsList, shoppingCartGoodsResponseVo, null, userLoginInfoDto, addShoppingCartGoodsRequestVo.getMenuType(), deliveryAmount);
        clearMsg(shoppingCartGoodsResponseVo, cartGoods.getCartGoodsUid());
        //设置更新响应信息
        setAddAndUpdateResponse(shoppingCartGoodsResponseVo, calculationDiscountResult, allCartGoodsList, null, partnerId, storeId, currentUserId, ShoppingCartConstant.ADD_AND_UPDATE, null);
        // 设置购物车版本号
        shoppingCartGoodsResponseVo.setCarVer(collageCartBaseService.incrementCartVersion(partnerId, storeId, crateUserId));
        //埋点添加购物车行为
        this.buriedPointShoppingCart(addShoppingCartGoodsRequestVo, spuId, productName);
        return ResponseUtil.success(shoppingCartGoodsResponseVo);
    }

    @Override
    public BaseResponse updateGoodsQty(UpdateShoppingCartGoodsQtyRequestVo updateShoppingCartGoodsQtyRequestVo) {
        return null;
    }

    @Override
    public BaseResponse getGoodsList(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        return null;
    }

    @Override
    public BaseResponse getGoodsListCheck(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo) {
        return null;
    }

    @Override
    public BaseResponse clear(ShoppingCartClearRequestVo request) {
        return null;
    }

    @Override
    public BaseResponse<ShoppingCartGoodsDto> getShoppingCartGoods(ShoppingCartInfoRequestVo shoppingCartInfoRequestVo, CreateOrderVo.PremiumExchangeActivity premiumExchangeActivity) {
        return null;
    }

    @Override
    public ActivityCalculationDiscountResponseDto.CalculationDiscountResult getActivityCalculationDiscountResponse(String partnerId, String storeId, String userId, String appId, Integer orderType, boolean isMember, List<CartGoods> cartGoodsList, List<ActivityCalculationDiscountRequestDto.CalculationDiscountCoupon> coupons, List<ShoppingCartInfoRequestVo.SendGoods> sendGoodsList, String menuType, Long distributionFee) {
        return null;
    }

    @Override
    public List<CartGoods> updateCartGoodsLegal(CartGoods cartGoods, String userId, ShoppingCartGoodsBaseResponseVo shoppingCartGoodsResponseVo, AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo, List<CartGoods> oldAllCartGoodsList) {
        //存储新添加的购物车信息
        List<CartGoods> nowCartGoodsList = new ArrayList<>();
        oldAllCartGoodsList.add(cartGoods);

        //当商品全部添加完毕,校验购物车商品(是否合法,上下架,点餐方式,是否在当前菜单中...),并移除非法商品
        CheckCartRequest checkCartRequest = assortmentSdkService.checkShoppingCartSdk(oldAllCartGoodsList, addShoppingCartGoodsRequestVo.getPartnerId(),
                addShoppingCartGoodsRequestVo.getShopId(), shoppingCartGoodsResponseVo, addShoppingCartGoodsRequestVo.getOrderType(),
                "", addShoppingCartGoodsRequestVo.getMenuType(),shoppingCartBaseService);
        if (checkCartRequest.getShoppingCartGoodsResponseVo() != null) {
            shoppingCartGoodsResponseVo.setToastMsg(checkCartRequest.getShoppingCartGoodsResponseVo().getToastMsg());
            shoppingCartGoodsResponseVo.setChanged(checkCartRequest.getShoppingCartGoodsResponseVo().getChanged());
        }
        List<CartGoods> allCartGoodsList = JSONArray.parseArray(JSONObject.toJSONString(checkCartRequest.getCartGoodsList()), CartGoods.class);

        //判断当前商品在购物车是否已存在,存在则数量＋1,不存在商品行 + 1
        allCartGoodsList.forEach(oldCartGoods -> {
            int index;
            if ((index = nowCartGoodsList.indexOf(oldCartGoods)) >= 0) {
                nowCartGoodsList.get(index).setQty(nowCartGoodsList.get(index).getQty() + cartGoods.getQty());
            } else {
                nowCartGoodsList.add(oldCartGoods);
            }
        });
        // 重新set购物车信息到缓存中
        assortmentSdkService.setShoppingCart(addShoppingCartGoodsRequestVo.getPartnerId(), addShoppingCartGoodsRequestVo.getShopId(),
                userId, nowCartGoodsList, addShoppingCartGoodsRequestVo.getSessionId(), addShoppingCartGoodsRequestVo.getTableNumber(), this.collageCartBaseService);
        oldAllCartGoodsList.clear();
        oldAllCartGoodsList.addAll(nowCartGoodsList);
        return nowCartGoodsList;
    }

    public List<CartGoods> getShoppingCart(AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo) {
        return null;
    }






    /**
     * 添加非商品券商品
     *
     * @param addShoppingCartGoodsRequestVo
     * @param cartGoods
     * @param goodsId
     * @param userId
     * @param shoppingCartGoodsResponseVo
     * @param allCartGoodsList
     */
    public List<CartGoods> addNotProductCouponGoods(AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo, CartGoods cartGoods
            , String goodsId, String userId, ShoppingCartGoodsBaseResponseVo shoppingCartGoodsResponseVo, List<CartGoods> allCartGoodsList) {

        // 校验合法性,更新缓存中购物车信息
        List<CartGoods> cartGoodsList = updateCartGoodsLegal(cartGoods, userId, shoppingCartGoodsResponseVo, addShoppingCartGoodsRequestVo, allCartGoodsList);

        // 如果购物车中有商品券，则当前添加的商品是特价商品时，需要提示“已选商品券，与其他优惠商品不同享，商品将恢复原价”
        // 拼单没有商品券、换购券
/*        boolean haveCouponProduct = allCartGoodsList.parallelStream().anyMatch(k -> k.getCartGoodsUid().startsWith(CommonsConstant.COUPON_PREFIX));
        if (haveCouponProduct && isSpecialGoods(addShoppingCartGoodsRequestVo.getPartnerId(), addShoppingCartGoodsRequestVo.getShopId(), userId, addShoppingCartGoodsRequestVo.getAppId(), goodsId, addShoppingCartGoodsRequestVo.getOrderType())) {
            // 如果购物车先加入商品券，再加入促销商品，toast提示“已选商品券，与其他优惠商品不同享，商品将恢复原价”
            setToastMsgIfNotExist(shoppingCartGoodsResponseVo, ShoppingCartConstant.HAS_GOODS_COUPON_WHEN_ADD_SPECIAL_GOODS);
        }*/

        return cartGoodsList;
    }

        /**
         * 拼单相关校验<br/>
         * 1、店铺id不能为空<br/>
         * 2、拼单不支持用商品券、换购券<br/>
         * 3、拼单发起人id不能为空<br/>
         * 4、拼单的基础信息不能为空<br/>
         * 5、判断拼单的锁定状态<br/>
         * 6、判单拼单的点餐位是否存在<br/>
         * 7、校验用户选好了状态
         * @param partnerId
         * @param storeId
         * @param crateUserId
         * @param addShoppingCartGoodsRequestVo
         */
        public void check(String partnerId,String storeId,String crateUserId,AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo){

        //店铺id不能为空
        if (StringUtils.isEmpty(addShoppingCartGoodsRequestVo.getShopId())){
            throw new ServiceException(ResponseResult.SHOPPING_CART_SHOP_ID_NOT_EMPTY);
        }

        //拼单不支持用商品券、换购券
        if (null != addShoppingCartGoodsRequestVo.getSpuId() && addShoppingCartGoodsRequestVo.getSpuId().startsWith(CommonsConstant.COUPON_PREFIX)){
            throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT);
        }
        // 拼单发起人id不能为空
        // 拼单购物相关的redis的key都需要拼单发起人id，所以这个值是不能为空的
        if (StringUtils.isEmpty(addShoppingCartGoodsRequestVo.getCreateCollageUserId())){
            throw new ServiceException(ResponseResult.COLLAGE_NOT_EXIST);
        }

        // 获取不到拼单的基础信息，抛出异常
        // 拼单的有效时间为1小时，当获取不到拼单的基础信息时，认为这个拼单没有发起、已经失效、已经结束
        Map<String, String> collageBase = collageCartBaseService.getCollageBase(partnerId,storeId,crateUserId);
        if(collageBase == null || collageBase.isEmpty()){
            throw new ServiceException(ResponseResult.COLLAGE_NOT_EXIST);
        }

        // 获取拼单的锁定状态，锁定，抛出异常
        // 发起人支付的时候需要对拼单进行锁定，当已锁定的时候，不能操作购物车
        Boolean collageLock = collageCartBaseService.getCollageLock(partnerId,storeId,crateUserId);
        if(collageLock != null && collageLock){
            throw new ServiceException(ResponseResult.COLLAGE_LOCK);
        }

        // 判单拼单的点餐位是否存在
        // 发起拼单、加入拼单，都会给用户创建点餐位，用来存储用户的购物车行id
        // 并设置其相应的购物车行id为空集合，没有点餐位，则认为该用户是没有加入拼单
        List<String> cartGoodsUids = collageCartBaseService.getCollageMemberHashKey(partnerId, storeId,crateUserId ,addShoppingCartGoodsRequestVo.getSessionId());
        if(cartGoodsUids == null){
            throw new ServiceException(ResponseResult.COLLAGE_NOT_ADD);
        }

        // 校验用户选好了状态
        // 只有用户不是选好了状态的时候才能更改购物车
        Boolean memberState = collageCartBaseService.getCollageMemStateHashKey(partnerId, storeId, crateUserId,addShoppingCartGoodsRequestVo.getSessionId());
        if(memberState != null && memberState){
            throw new ServiceException(ResponseResult.COLLAGE_ALREADY_CHOOSE);
        }

    }

    /**
     * 购物车版本锁检查和加锁
     * @param partnerId
     * @param storeId
     * @param crateUserId
     * @param addShoppingCartGoodsRequestVo
     */
    private void dolock(String partnerId,String storeId,String crateUserId,AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo) {
        // 设置版本锁控制购物车只能一个人进行操作
        Integer carVer = addShoppingCartGoodsRequestVo.getCarVer();
        if (carVer == null || carVer < 1) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_VERSION_ERROR);
        }
        // 构建拼单购物车版本号缓存key
        String collageCartVerKey = genCollageCarVerKey(partnerId, storeId, crateUserId);
        Integer cartVersion = collageCartBaseService.getCartVersion(collageCartVerKey);
        if (!carVer.equals(cartVersion)) {
            throw new ServiceException(ResponseResult.SHOPPING_CART_VERSION_ERROR);
        }
        redisCache.getValue(collageCartVerKey);
        boolean lock = RedisLock.getInstance(redisCache.getRedisTemplate()).lock(collageCartVerKey);
        if (!lock) {
            //加锁失败
            throw new ServiceException(ResponseResult.SHOPPING_CART_VERSION_ERROR);
        }
    }

    /**
     * 购物车版本解锁
     * @param partnerId
     * @param storeId
     * @param crateUserId
     */
    private void doUnlock(String partnerId,String storeId,String crateUserId) {
        String collageCartVerKey = genCollageCarVerKey(partnerId, storeId, crateUserId);
        RedisLock.getInstance(redisCache.getRedisTemplate()).unlock(collageCartVerKey);
    }

    /**
     * 构建拼单购物车版本号缓存key
     * @param partnerId
     * @param storeId
     * @param userId
     * @return
     */
    private String genCollageCarVerKey(String partnerId, String storeId, String userId) {
        return MessageFormat.format(RedisKeyConstant.COLLAGE_CART_VER_KEY, partnerId, storeId, userId);
    }

}
