package cn.freemud.service.impl;

import cn.freemud.enums.RedisCacheEnum;
import cn.freemud.redis.RedisCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class RedisService {
    @Autowired
    private RedisCache redisCache;

    /**
     * 指定的key值自增，并指定缓存过期时间
     */
    public Long increment(String key, long expire, TimeUnit timeUnit) {
        Long increment = redisCache.opsForValue().increment(key, 1);
        redisCache.updateTTL(key, expire, timeUnit);
        return increment;
    }

    /**
     * 保存支付交易好订单关系，并指定缓存过期时间
     */
    public void savePaymentTransIdOrder(String key, String orderId, long expire, TimeUnit timeUnit) {
        redisCache.save(key, orderId, expire, timeUnit);
    }
}
