package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ecology.VirtualBindStoreResponse;
import cn.freemud.entities.dto.ecology.VirtualStoreRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;

/**
 * 生态服务
 * @author: kai.ding
 * @date:  
 */
@FeignClient(name = "ECOLOGY-ADMIN-APPLICATION", url = "${saas.ecology.admin.application.feign.url}")
public interface EcologyAdminApplicationClient {

    /**
     * 获取虚拟门店
     */
    @PostMapping(value = "ecology/api/app/info/getBuyBindVirtualStore", produces = MediaType.APPLICATION_JSON_VALUE ,consumes = MediaType.APPLICATION_JSON_VALUE )
    BaseResponse<VirtualBindStoreResponse> getBuyBindVirtualStore(@RequestBody VirtualStoreRequest virtualStoreRequest);
}
