/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CouponService
 * @Package cn.freemud.service
 * @Description:
 * @author: pengfei.liu
 * @date: 2020/11/23
 * @version V1.0
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.active.impl;

import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.vo.ShoppingCartInfoRequestVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.service.active.ActiveService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service("cocoActiveService")
public class CocoActiveServiceImpl implements ActiveService {

    /**
     * 用户只能选择1商品和1数量传给促销
     * @param calculationSharingDiscountRequestDto
     * @param chooseGoods
     */
    @Override
    public void buildChooseGoodsService(CalculationSharingDiscountRequestDto calculationSharingDiscountRequestDto, List<ShoppingCartInfoRequestVo.ChooseGood> chooseGoods) {

        // 买一赠一寄件活动
        // coco一次只能选择一种商品，一种商品只能选择一件
        List<CalculationSharingDiscountRequestDto.CalculationActivityReqVO> selectActivityList = calculationSharingDiscountRequestDto.getSelectActivityList() == null ? new ArrayList<>() : calculationSharingDiscountRequestDto.getSelectActivityList();

        if(null != chooseGoods && !chooseGoods.isEmpty()){

            // 从用户选择的商品中选择第一个
            ShoppingCartInfoRequestVo.ChooseGood chooseGood = chooseGoods.get(0);

            CalculationSharingDiscountRequestDto.CalculationActivityReqVO  calculationActivityReqVO = new CalculationSharingDiscountRequestDto.CalculationActivityReqVO();
            calculationActivityReqVO.setActivityCode(chooseGood.getActiveCode());
            calculationActivityReqVO.setActivityType(ActivityTypeEnum.TYPE_63.getCode());

            // 设置商品的数量为1
            List<CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO> sendGoods = new ArrayList<>();
            CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO sendGood = new CalculationSharingDiscountRequestDto.CalculationSendGoodsReqVO();
            sendGood.setGoodsId(chooseGood.getGoodsId());
            sendGood.setGoodsQuantity(1);
            sendGoods.add(sendGood);
            calculationActivityReqVO.setSendGoods(sendGoods);

            selectActivityList.add(calculationActivityReqVO);
        }
        calculationSharingDiscountRequestDto.setSelectActivityList(selectActivityList);

    }
}
