//package cn.freemud.service.process.WechatPush;
//
//
//import cn.freemud.amp.body.OrderBody;
//import cn.freemud.entities.dto.QueryOrdersResponseDto;
//import cn.freemud.entities.vo.WxappPluginVo;
//import cn.freemud.enums.PluginAuditStatusEnum;
//import cn.freemud.enums.YesOrNoEnum;
//import cn.freemud.manager.OpenPlatformWxappPluginBindManager;
//import cn.freemud.service.OrderDistributeMQService;
//import cn.freemud.utils.LogUtil;
//import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerConfig;
//import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformWxapp;
//import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
//import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerConfigManager;
//import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappManager;
//import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
//import com.freemud.sdk.api.assortment.order.enums.OrderSdkType;
//import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
//import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
//import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
//import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
//import com.freemud.sdk.api.assortment.orderdistributor.request.DisRequest;
//import com.google.gson.Gson;
//import org.apache.commons.collections4.CollectionUtils;
//import org.apache.commons.lang.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.ArrayList;
//import java.util.List;
//import java.util.Objects;
//import java.util.stream.Collectors;
//
///**
// * All rights Reserved, Designed By www.freemud.cn
// *
// * @version V1.0
// * @Title: ${FILE_NAME}
// * @Package com.freemud.mail.core
// * @Description: $MQ微信订单上送处理类
// * @author: aiqi.gong
// * @date: 2019/3/21 18:37
// * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
// * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
// */
//@Service
//public class WechatPushProcessor {
//    private final static String COUPON_PLUGINS = "wx8e98654a3e2f42f7";
//
//    private static Gson gson = new Gson();
//
//    @Autowired
//    private AssortmentOpenPlatformPartnerConfigManager openPlatformPartnerConfigManager;
//    @Autowired
//    private OpenPlatformWxappPluginBindManager openPlatformWxappPluginBindManager;
//
//    /**
//     * 微信订单上送队列分发器
//     */
//    @Autowired
//    private OrderDistributeMQService orderDistributeMQService;
//    //聚合订单服务
//    @Autowired
//    private OrderCenterSdkService orderCenterSdkService;
//
//    @Autowired
//    private AssortmentOpenPlatformWxappManager openPlatformWxappManager;
////    @Autowired
////    private UserServiceImpl userService;
//    @Autowired
//    private AssortmentCustomerInfoManager customerInfoManager;
//
//    /**
//     * 订单创建上送微信
//     *
//     * @param userLoginInfoDto 用户信息
//     * @param oId              订单ID
//     * @param companyId        商户号
//     */
//    public boolean statusOrderCreate(AssortmentCustomerInfoVo userLoginInfoDto, String oId, String companyId) {
//        DisRequest disRequest = null;
//        try {
//            // 判断当前小程序是否开通推荐优惠插件并启用
//            if (checkWechatOpenPlugin(userLoginInfoDto)) {
//                return false;
//            }
//            //查询 orderBean
//            BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
//            baseQueryOrderRequest.setOrderId(oId);
//            QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
//            if (null == userLoginInfoDto || null == queryOrderByIdResponse || null == queryOrderByIdResponse.getData()) {
//                return false;
//            }
//            QueryOrdersResponse.DataBean.OrderBean orderBean = queryOrderByIdResponse.getData();
//            // 获取当前商户微信支付mchId
//            AssortmentOpenPlatformWxapp wxApp = openPlatformWxappManager.findByPartnerIdAndWxappId(userLoginInfoDto.getPartnerId(), userLoginInfoDto.getWxAppId());
//            if (wxApp == null || wxApp.getMchId() == null) {
//                return false;
//            }
//
//            OrderBody orderBody = convent2OrderBody(orderBean);
//            //设置微信上送信息集
//            orderBody.seSyncStatusInfo(getSyncStatusInfo(wxApp.getMchId(), userLoginInfoDto));
//
//            //MQ消息发送
//            disRequest = convent2DisRequest(orderBody);
//            orderDistributeMQService.messageDistribute(disRequest);
//        } catch (Exception e) {
//        }
//        return true;
//    }
//
//
//    /**
//     * 订单支付上送微信
//     *
//     * @param orderBean
//     */
//    public void statusOrderPay(QueryOrdersResponseDto.DataBean.OrderBean orderBean, String sessionId, String paidNo
//            , String outTradeNo, String endTransId, String platformMchId, String terminalId) {
//        if (null == orderBean) {
//            return;
//        }
//        try {
//            AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(sessionId);
//            if (null == userLoginInfoDto) {
//                return;
//            }
//            // 兼容老支付逻辑
//            String mchId = null;
//            if(StringUtils.isBlank(platformMchId)) {
//                // 获取当前商户微信支付mchId
//                AssortmentOpenPlatformWxapp wxApp = openPlatformWxappManager.findByPartnerIdAndWxappId(userLoginInfoDto.getPartnerId(), userLoginInfoDto.getWxAppId());
//                if (wxApp == null || wxApp.getMchId() == null) {
//                    return;
//                }
//                mchId = wxApp.getMchId();
//            } else {
//                mchId = platformMchId;
//            }
//            OrderBody orderBody = convent2OrderBody(orderBean);
//            //设置微信上送信息集
//            orderBody.seSyncStatusInfo(getSyncStatusInfo(mchId, userLoginInfoDto, paidNo, outTradeNo, endTransId, terminalId));
//            //MQ消息发送
//            DisRequest disRequest = convent2DisRequest(orderBody);
//            orderDistributeMQService.messageDistribute(disRequest);
//        } catch (Exception e) {
//        }
//
//
//    }
//
//    /**
//     * 构造MQ分发消息体
//     *
//     * @param orderBody
//     * @return
//     */
//    private DisRequest convent2DisRequest(OrderBody orderBody) {
//
//        DisRequest disRequest = new DisRequest();
//        disRequest.setExtJson(gson.toJson(orderBody));
//        disRequest.setStatus(String.valueOf(orderBody.getOrderBean().getStatus()));
//        disRequest.setPartnerId(orderBody.getOrderBean().getCompanyId());
//        return disRequest;
//    }
//
//    /**
//     * 构造微信上送信息集
//     *
//     * @param mchId
//     * @param userLoginInfoDto
//     * @return
//     */
//    private OrderBody.SyncStatusInfo getSyncStatusInfo(String mchId, AssortmentCustomerInfoVo userLoginInfoDto) {
//
//        OrderBody.SyncStatusInfo syncStatusInfo = new OrderBody.SyncStatusInfo();
//        syncStatusInfo.setMchId(mchId);
//        syncStatusInfo.setWxAppid(userLoginInfoDto.getWxAppId());
//        syncStatusInfo.setOpenId(userLoginInfoDto.getOpenId());
//        syncStatusInfo.setSessionKey(userLoginInfoDto.getSessionKey());
//        return syncStatusInfo;
//
//    }
//
//    /**
//     * 构造微信上送信息集
//     *
//     * @param mchId
//     * @param userLoginInfoDto
//     * @return
//     */
//    private OrderBody.SyncStatusInfo getSyncStatusInfo(String mchId, AssortmentCustomerInfoVo userLoginInfoDto, String paidNo, String outTradeNo
//            , String endTransId, String terminalId) {
//
//        OrderBody.SyncStatusInfo syncStatusInfo = new OrderBody.SyncStatusInfo();
//        syncStatusInfo.setMchId(mchId);
//        syncStatusInfo.setWxAppid(userLoginInfoDto.getWxAppId());
//        syncStatusInfo.setOpenId(userLoginInfoDto.getOpenId());
//        syncStatusInfo.setSessionKey(userLoginInfoDto.getSessionKey());
//        syncStatusInfo.setTransactionId(paidNo);
//        syncStatusInfo.setOutTradeNo(outTradeNo);
//        syncStatusInfo.setEndTransId(endTransId);
//        syncStatusInfo.setTerminalId(terminalId);
//        return syncStatusInfo;
//
//    }
//
//    /**
//     * 判断是否开启优惠插件
//     *
//     * @param userLoginInfoDto
//     * @return true 未开启 false 已开启插件
//     */
//    private boolean checkWechatOpenPlugin(AssortmentCustomerInfoVo userLoginInfoDto) {
//        List<WxappPluginVo> openPlatformWxappPluginBinds = openPlatformWxappPluginBindManager.queryByWxAppid(userLoginInfoDto.getWxAppId());
//        List<WxappPluginVo> pluginVoList = openPlatformWxappPluginBinds.stream().filter(wxappPluginVo -> wxappPluginVo.getPluginAppid().equals(COUPON_PLUGINS)).filter(wxappPluginVo -> wxappPluginVo.getOperateStatus() == 1).collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(pluginVoList) || pluginVoList.size() != 1) {
//            return true;
//        }
//        WxappPluginVo wxappPluginVo = pluginVoList.get(0);
//
//        if (!Objects.equals(wxappPluginVo.getAuditStatus(), PluginAuditStatusEnum.PASS.getCode()) || !Objects.equals(wxappPluginVo.getOperateStatus(), YesOrNoEnum.YES.getCode())) {
//            return true;
//        }
//        return false;
//    }
//
//    private static OrderBody convent2OrderBody(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
//        if (orderBean == null) {
//            return null;
//        }
//        OrderBody orderBody = new OrderBody();
//        OrderBody.OrderBean orderBeanNew = new OrderBody.OrderBean();
//        orderBeanNew.setShopAddress(orderBean.getShopAddress());
//        orderBeanNew.setAddress(orderBean.getAddress());
//        orderBeanNew.setShopPhone(orderBean.getShopPhone());
//        orderBeanNew.setAmount(orderBean.getAmount().intValue());
//        orderBeanNew.setCancelReason(orderBean.getCancelReason());
//        orderBeanNew.setCompanyId(orderBean.getCompanyId());
//        orderBeanNew.setCourierName(orderBean.getCourierName());
//        orderBeanNew.setCourierPhone(orderBean.getCourierPhone());
//        orderBeanNew.setCreateUser(orderBean.getCreateUser());
//        orderBeanNew.setCustomerOrder(orderBean.getCustomerOrder());
//        orderBeanNew.setEvaluateStatus(orderBean.getEvaluateStatus());
//        orderBeanNew.setGmtAccept(orderBean.getGmtAccept());
//        orderBeanNew.setExtInfo(orderBean.getExtInfo());
//        orderBeanNew.setGmtCreate(orderBean.getGmtCreate());
//        orderBeanNew.setGmtExpect(orderBean.getGmtExpect());
//        orderBeanNew.setGmtModified(orderBean.getGmtModified());
//        orderBeanNew.setGmtPay(orderBean.getGmtPay());
//        orderBeanNew.setHasRefund(orderBean.getHasRefund());
//        orderBeanNew.setLatitude(orderBean.getLatitude());
//        orderBeanNew.setLongitude(orderBean.getLongitude());
//        orderBeanNew.setOid(orderBean.getOid());
//        orderBeanNew.setOrderType(orderBean.getOrderType());
//        orderBeanNew.setOtherCode(orderBean.getOtherCode());
//        orderBeanNew.setPartition(orderBean.getPartition());
//        orderBeanNew.setPayChannel(orderBean.getPayChannel());
//        orderBeanNew.setPayChannelName(orderBean.getPayChannelName());
//        orderBeanNew.setPayStatus(orderBean.getPayStatus());
//        orderBeanNew.setPayType(orderBean.getPayType());
//        orderBeanNew.setPayVoucher(orderBean.getPayVoucher());
//        orderBeanNew.setPhone(orderBean.getPhone());
//        orderBeanNew.setPosId(orderBean.getPosId());
//        orderBeanNew.setRemark(orderBean.getRemark());
//        orderBeanNew.setDaySeq(orderBean.getDaySeq());
//        orderBeanNew.setShopId(orderBean.getShopId());
//        orderBeanNew.setShopName(orderBean.getShopName());
//        orderBeanNew.setSource(orderBean.getSource());
//        orderBeanNew.setSourceName(orderBean.getSourceName());
//        orderBeanNew.setStatus(orderBean.getStatus());
//        orderBeanNew.setTakeAddress(orderBean.getTakeAddress());
//        orderBeanNew.setQueueIndex(orderBean.getQueueIndex());
//        orderBeanNew.setType(orderBean.getType());
//        orderBeanNew.setUserId(orderBean.getUserId());
//        orderBeanNew.setUserName(orderBean.getUserName());
//        orderBeanNew.setUserType(orderBean.getUserType());
//        orderBeanNew.setOperateTakeOrderTime(orderBean.getOperateTakeOrderTime());
//        orderBeanNew.setOperateWaitPayTime(orderBean.getOperateWaitPayTime());
//        orderBeanNew.setOperateReceiptTime(orderBean.getOperateReceiptTime());
//        orderBeanNew.setOperateDistributionTime(orderBean.getOperateDistributionTime());
//        orderBeanNew.setOperateCompleteTime(orderBean.getOperateCompleteTime());
//        orderBeanNew.setOperateCalcelTime(orderBean.getOperateCalcelTime());
//        orderBeanNew.setOperatePefuseTime(orderBean.getOperatePefuseTime());
//        orderBeanNew.setOperateCompleteMakeTime(orderBean.getOperateCompleteMakeTime());
//        orderBeanNew.setDeliverStatus(orderBean.getDeliverStatus());
//        orderBeanNew.setRiderName(orderBean.getRiderName());
//        orderBeanNew.setRiderText(orderBean.getRiderText());
//        orderBeanNew.setRiderPhoto(orderBean.getRiderPhoto());
//        orderBeanNew.setShopImageUrl(orderBean.getShopImageUrl());
//        orderBeanNew.setRiderPhone(orderBean.getRiderPhone());
//        orderBeanNew.setReceiveTime(orderBean.getReceiveTime());
//        orderBeanNew.setDepatchTime(orderBean.getDepatchTime());
//        orderBeanNew.setArriveShopTime(orderBean.getArriveShopTime());
//        orderBeanNew.setSendTime(orderBean.getSendTime());
//        orderBeanNew.setCompleteTime(orderBean.getCompleteTime());
//        orderBody.setOrderBean(orderBeanNew);
//        orderBeanNew.setProductList(convent2ProductList1(orderBean.getProductList()));
//        return orderBody;
//    }
//
//    private static List<OrderBody.OrderBean.ProductBean> convent2ProductList1(List<QueryOrdersResponseDto.DataBean.OrderBean.ProductBean> productList) {
//
//        List<OrderBody.OrderBean.ProductBean> productBeanList = new ArrayList<>();
//
//        for (QueryOrdersResponseDto.DataBean.OrderBean.ProductBean productBean : productList) {
//            productBeanList.add(convent2Product1(productBean));
//        }
//        return productBeanList;
//
//    }
//
//    private static OrderBody.OrderBean.ProductBean convent2Product1(QueryOrdersResponseDto.DataBean.OrderBean.ProductBean productBeanOld) {
//
//        if (productBeanOld == null) {
//            return null;
//        }
//        OrderBody.OrderBean.ProductBean productBean = new OrderBody.OrderBean.ProductBean();
//        productBean.setCustomerCode(productBeanOld.getCustomerCode());
//        productBean.setNumber(productBeanOld.getNumber());
//        productBean.setOpid(productBeanOld.getOpid());
//        productBean.setOrderId(productBeanOld.getOrderId());
//        productBean.setProductId(productBeanOld.getProductId());
//        productBean.setPicture(productBeanOld.getPicture());
//        productBean.setPrice(productBeanOld.getPrice());
//        productBean.setSalePrice(productBeanOld.getSalePrice());
//        productBean.setProductName(productBeanOld.getProductName());
//        productBean.setSequence(productBeanOld.getSequence());
//        productBean.setSpecification(productBeanOld.getSpecification());
//        productBean.setSpecificationName(productBeanOld.getSpecificationName());
//        productBean.setUnit(productBeanOld.getUnit());
//        productBean.setAddInfo(productBeanOld.getAddInfo());
//        productBean.setDiscountList(convent2DiscountList1(productBeanOld.getDiscountList()));
//        return productBean;
//    }
//
//    private static List<OrderBody.OrderBean.ProductBean.ProductDiscount> convent2DiscountList1(List<QueryOrdersResponseDto.DataBean.OrderBean.ProductBean.ProductDiscount> discountList) {
//
//        List<OrderBody.OrderBean.ProductBean.ProductDiscount> productDiscountList = new ArrayList<>();
//
//        for (QueryOrdersResponseDto.DataBean.OrderBean.ProductBean.ProductDiscount productDiscount : discountList) {
//            productDiscountList.add(convent2Discount1(productDiscount));
//        }
//        return productDiscountList;
//
//    }
//
//    private static OrderBody.OrderBean.ProductBean.ProductDiscount convent2Discount1(QueryOrdersResponseDto.DataBean.OrderBean.ProductBean.ProductDiscount productDiscountOld) {
//        if (productDiscountOld == null) {
//            return null;
//        }
//        OrderBody.OrderBean.ProductBean.ProductDiscount productDiscount = new OrderBody.OrderBean.ProductBean.ProductDiscount();
//        productDiscount.setDiscountId(productDiscountOld.getDiscountId());
//        productDiscount.setDiscountDesc(productDiscountOld.getDiscountDesc());
//        productDiscount.setDiscountType(productDiscountOld.getDiscountType());
//        productDiscount.setDiscountPrice(productDiscountOld.getDiscountPrice());
//        productDiscount.setDiscountQty(productDiscountOld.getDiscountQty());
//        productDiscount.setDiscountAmount(productDiscountOld.getDiscountAmount());
//        productDiscount.setCustomerCode(productDiscountOld.getCustomerCode());
//        productDiscount.setAddInfo(productDiscountOld.getAddInfo());
//        productDiscount.setProductId(productDiscountOld.getProductId());
//        return productDiscount;
//
//    }
//
//
//    private static OrderBody convent2OrderBody(com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse.DataBean.OrderBean orderBean) {
//        if (orderBean == null) {
//            return null;
//        }
//        OrderBody orderBody = new OrderBody();
//        OrderBody.OrderBean orderBeanNew = new OrderBody.OrderBean();
//        orderBeanNew.setShopAddress(orderBean.getShopAddress());
//        orderBeanNew.setAddress(orderBean.getAddress());
//        orderBeanNew.setShopPhone(orderBean.getShopPhone());
//        orderBeanNew.setAmount(orderBean.getAmount().intValue());
//        orderBeanNew.setCancelReason(orderBean.getCancelReason());
//        orderBeanNew.setCompanyId(orderBean.getCompanyId());
//        orderBeanNew.setCourierName(orderBean.getCourierName());
//        orderBeanNew.setCourierPhone(orderBean.getCourierPhone());
//        orderBeanNew.setCreateUser(orderBean.getCreateUser());
//        orderBeanNew.setCustomerOrder(orderBean.getCustomerOrder());
//        orderBeanNew.setEvaluateStatus(orderBean.getEvaluateStatus());
//        orderBeanNew.setGmtAccept(orderBean.getGmtAccept());
//        orderBeanNew.setExtInfo(orderBean.getExtInfo());
//        orderBeanNew.setGmtCreate(orderBean.getGmtCreate());
//        orderBeanNew.setGmtExpect(orderBean.getGmtExpect());
//        orderBeanNew.setGmtModified(orderBean.getGmtModified());
//        orderBeanNew.setGmtPay(orderBean.getGmtPay());
//        orderBeanNew.setHasRefund(orderBean.getHasRefund());
//        orderBeanNew.setLatitude(orderBean.getLatitude());
//        orderBeanNew.setLongitude(orderBean.getLongitude());
//        orderBeanNew.setOid(orderBean.getOid());
//        orderBeanNew.setOrderType(orderBean.getOrderType());
//        orderBeanNew.setOtherCode(orderBean.getOtherCode());
//        orderBeanNew.setPartition(orderBean.getPartition());
//        orderBeanNew.setPayChannel(orderBean.getPayChannel());
//        orderBeanNew.setPayChannelName(orderBean.getPayChannelName());
//        orderBeanNew.setPayStatus(orderBean.getPayStatus());
//        orderBeanNew.setPayType(orderBean.getPayType());
//        orderBeanNew.setPayVoucher(orderBean.getPayVoucher());
//        orderBeanNew.setPhone(orderBean.getPhone());
//        orderBeanNew.setPosId(orderBean.getPosId());
//        orderBeanNew.setRemark(orderBean.getRemark());
//        orderBeanNew.setDaySeq(orderBean.getDaySeq());
//        orderBeanNew.setShopId(orderBean.getShopId());
//        orderBeanNew.setShopName(orderBean.getShopName());
//        orderBeanNew.setSource(orderBean.getSource());
//        orderBeanNew.setSourceName(orderBean.getSourceName());
//        orderBeanNew.setStatus(orderBean.getStatus());
//        orderBeanNew.setTakeAddress(orderBean.getTakeAddress());
//        orderBeanNew.setQueueIndex(orderBean.getQueueIndex());
//        orderBeanNew.setType(orderBean.getType());
//        orderBeanNew.setUserId(orderBean.getUserId());
//        orderBeanNew.setUserName(orderBean.getUserName());
//        orderBeanNew.setUserType(orderBean.getUserType());
//        orderBeanNew.setProductList(convent2ProductList(orderBean.getProductList()));
//        orderBeanNew.setOperateTakeOrderTime(orderBean.getOperateTakeOrderTime());
//        orderBeanNew.setOperateWaitPayTime(orderBean.getOperateWaitPayTime());
//        orderBeanNew.setOperateReceiptTime(orderBean.getOperateReceiptTime());
//        orderBeanNew.setOperateDistributionTime(orderBean.getOperateDistributionTime());
//        orderBeanNew.setOperateCompleteTime(orderBean.getOperateCompleteTime());
//        orderBeanNew.setOperateCalcelTime(orderBean.getOperateCalcelTime());
//        orderBeanNew.setOperatePefuseTime(orderBean.getOperatePefuseTime());
//        orderBeanNew.setOperateCompleteMakeTime(orderBean.getOperateCompleteMakeTime());
//        orderBeanNew.setDeliverStatus(orderBean.getDeliverStatus());
//        orderBeanNew.setRiderName(orderBean.getRiderName());
//        orderBeanNew.setRiderText(orderBean.getRiderText());
//        orderBeanNew.setRiderPhoto(orderBean.getRiderPhoto());
//        orderBeanNew.setShopImageUrl(orderBean.getShopImageUrl());
//        orderBeanNew.setRiderPhone(orderBean.getRiderPhone());
//        orderBeanNew.setReceiveTime(orderBean.getReceiveTime());
//        orderBeanNew.setDepatchTime(orderBean.getDepatchTime());
//        orderBeanNew.setArriveShopTime(orderBean.getArriveShopTime());
//        orderBeanNew.setSendTime(orderBean.getSendTime());
//        orderBeanNew.setCompleteTime(orderBean.getCompleteTime());
//        orderBody.setOrderBean(orderBeanNew);
//        return orderBody;
//    }
//
//    private static List<OrderBody.OrderBean.ProductBean> convent2ProductList(List<QueryOrdersResponse.DataBean.OrderBean.ProductBean> productList) {
//        List<OrderBody.OrderBean.ProductBean> productBeanList = new ArrayList<>();
//
//        for (QueryOrdersResponse.DataBean.OrderBean.ProductBean productBean : productList) {
//            productBeanList.add(convent2Product(productBean));
//        }
//        return productBeanList;
//    }
//
//    public static OrderBody.OrderBean.ProductBean convent2Product(QueryOrdersResponse.DataBean.OrderBean.ProductBean productBeanOld) {
//        if (productBeanOld == null) {
//            return null;
//        }
//        OrderBody.OrderBean.ProductBean productBean = new OrderBody.OrderBean.ProductBean();
//        productBean.setCustomerCode(productBeanOld.getCustomerCode());
//        productBean.setNumber(productBeanOld.getNumber());
//        productBean.setOpid(productBeanOld.getOpid());
//        productBean.setOrderId(productBeanOld.getOrderId());
//        productBean.setProductId(productBeanOld.getProductId());
//        productBean.setParentProduct(productBeanOld.getParentProductId());
//        productBean.setPicture(productBeanOld.getPicture());
//        productBean.setPrice(productBeanOld.getPrice());
//        productBean.setSalePrice(productBeanOld.getSalePrice());
//        productBean.setProductName(productBeanOld.getProductName());
//        productBean.setSequence(productBeanOld.getSequence());
//        productBean.setSpecification(productBeanOld.getSpecification());
//        productBean.setSpecificationName(productBeanOld.getSpecificationName());
//        productBean.setUnit(productBeanOld.getUnit());
//        productBean.setAddInfo(productBeanOld.getAddInfo());
//        productBean.setDiscountList(convent2DiscountList(productBeanOld.getDiscountList()));
//        return productBean;
//    }
//
//    private static List<OrderBody.OrderBean.ProductBean.ProductDiscount> convent2DiscountList(List<QueryOrdersResponse.DataBean.OrderBean.ProductBean.ProductDiscount> discountList) {
//        List<OrderBody.OrderBean.ProductBean.ProductDiscount> productDiscountList = new ArrayList<>();
//
//        for (QueryOrdersResponse.DataBean.OrderBean.ProductBean.ProductDiscount productDiscount : discountList) {
//            productDiscountList.add(convent2Discount(productDiscount));
//        }
//        return productDiscountList;
//    }
//
//    public static OrderBody.OrderBean.ProductBean.ProductDiscount convent2Discount(QueryOrdersResponse.DataBean.OrderBean.ProductBean.ProductDiscount productDiscountOld) {
//        if (productDiscountOld == null) {
//            return null;
//        }
//        OrderBody.OrderBean.ProductBean.ProductDiscount productDiscount = new OrderBody.OrderBean.ProductBean.ProductDiscount();
//        productDiscount.setDiscountId(productDiscountOld.getDiscountId());
//        productDiscount.setDiscountDesc(productDiscountOld.getDiscountDesc());
//        productDiscount.setDiscountType(productDiscountOld.getDiscountType());
//        productDiscount.setDiscountPrice(productDiscountOld.getDiscountPrice());
//        productDiscount.setDiscountQty(productDiscountOld.getDiscountQty());
//        productDiscount.setDiscountAmount(productDiscountOld.getDiscountAmount());
//        productDiscount.setCustomerCode(productDiscountOld.getCustomerCode());
//        productDiscount.setAddInfo(productDiscountOld.getAddInfo());
//        productDiscount.setProductId(productDiscountOld.getProductId());
//        return productDiscount;
//    }
//
//    /**
//     * 获取使用新订单接口还是老订单接口
//     *
//     * @param partnerId
//     * @return
//     */
//    private OrderSdkType getDefaultOrderSdkType(String partnerId) {
//        final String partnerKey = "orderSdkType";
//        final String newOrder = "new";
//        AssortmentOpenPlatformPartnerConfig partnerConfig = openPlatformPartnerConfigManager.selectPartnerConfigByPartnerKey(partnerId, partnerKey, 1);
//        if (partnerConfig == null || StringUtils.isBlank(partnerConfig.getPartnerValue())
//                || !newOrder.equals(partnerConfig.getPartnerValue())) {
//            return OrderSdkType.OLD;
//        }
//        return OrderSdkType.NEW;
//    }
//
//
//}
