/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CreateOrderResponseVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/23 11:10
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import cn.freemud.entities.live.WeChatReportVO;
import cn.freemud.entities.ttpay.OrderInfo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class CreateOrderResponseVo {

    @ApiModelProperty(value = "订单id")
    private String oid;
    @ApiModelProperty(value = "微信appid")
    private String wxappId;
    @ApiModelProperty(value = "时间戳")
    private String timestamp;
    @ApiModelProperty(value = "随机字符串")
    private String nonceStr;
    @ApiModelProperty(value = "订单详情扩展字符串")
    private String packageX;
    @ApiModelProperty(value = "签名方式")
    private String signType;
    @ApiModelProperty(value = "签名")
    private String sign;

    /**
     * 是否支持成功 支付金额为0，现为商品券时返回true，其余为false
     */
    @ApiModelProperty(value = "是否支持成功")
    private Boolean paySuccess;
    /**
     * 非码支付商户号  用户数据上报
     */
    @ApiModelProperty(value = "非码支付商户号")
    private String fmId;

    /**
     * 下单版本号
     */
    @ApiModelProperty(value = "下单版本号")
    private Integer orderUpdateVer;

    /**
     * 订单类型
     */
    @ApiModelProperty(value = "订单类型")
    private Integer orderType;

    /**
     * 支付宝参数 唤起支付宝支付使用
     */
    @ApiModelProperty(value = "支付宝参数 唤起支付宝支付使用")
    private String orderStr;

    /**
     * 抖音支付返回数据
     */
    private OrderInfo orderInfo;

    /**
     * pay_id : 微信小程序支付
     */
    private String payId;


    private WeChatReportVO weChatReportVO;
}
