package com.freemud.sdk.api.assortment.shoppingcart.util;

import ch.qos.logback.classic.Level;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.application.sdk.api.log.ApiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.base.log
 * @Description: 异常日志打印
 * @author: aiqi.gong
 * @date: 2017/6/21 10:43
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class ShoppingSdkLogUtil implements BeanFactoryAware {
    private static Logger logger = LoggerFactory.getLogger(com.freemud.application.sdk.api.log.ErrorLog.class);

    @Value("${print-debug-log:false}")
    private boolean printDebug;

    private static BeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ShoppingSdkLogUtil.beanFactory = beanFactory;
    }

    public void debug(String message, Object... params) {
        if (logger.isDebugEnabled()) {
            this.info(message, params);
        }
    }
    public void info(String message, Object... params) {
        if (printDebug) {
            Object[] clone = params != null ? params.clone() : new String[]{};
            String param1 = "", param2 = "", param3 = "";
            if (params.length > 0) {
                param1 = clone[0] instanceof String ? (String) clone[0] : JSON.toJSONString(clone[0]);
            }
            if (params.length > 1) {
                param2 = clone[1] instanceof String ? (String) clone[1] : JSON.toJSONString(clone[1]);
            }
            if (params.length > 2) {
                param3 = clone[2] instanceof String ? (String) clone[2] : JSON.toJSONString(clone[2]);
            }
            try {
                ApiLog.printLog(MessageFormatter.arrayFormat(message, params).getMessage(), param1, param2, param3);
            } catch (Exception e) {
                com.freemud.application.sdk.api.log.ErrorLog.errorDev("","LogUtil.printLog ".concat(message), e, params);
            }
        }
    }

    public void error(String message, Exception e, Object... params) {
        com.freemud.application.sdk.api.log.ErrorLog.errorDev("",message, e, params);
    }

    public void errorSe(String message, Exception e, Object... params) {
        com.freemud.application.sdk.api.log.ErrorLog.errorSe(message, e, params);
    }
    private static ShoppingSdkLogUtil getLogUtil() {
        return beanFactory.getBean("shoppingSdkLogUtil", ShoppingSdkLogUtil.class);
    }

    public static void debugLog(String message, Object... params) {
        if (logger.isDebugEnabled()) {
            getLogUtil().debug(message, params);
        }
    }
    public static void infoLog(String message, Object... params) {
        getLogUtil().info(message,params);
    }
    public static void errorLog(String message,Exception e, Object... params) {
        getLogUtil().error(message,e,params);
    }


    public static void infoConvertJson(String appName, String trackingNo, Class logClass, String message, Exception ex) {
        if (ex==null){
            getLogUtil().info(message);
        }else {
            getLogUtil().error(message,ex);
        }
    }

    public static void errorConvertJson(String appName, String trackingNo, Class logClass, String message, Exception ex) {
        getLogUtil().error(message,ex);
    }

    public static void printLog(String appName, String trackingNo, Class logClass, String message, Exception ex, Level level) {
        if (ex == null) {
            getLogUtil().info(message);
        } else {
            getLogUtil().error(message, ex);
        }
    }

    public static void printLog( String message, String param1, String param2) {
        getLogUtil().info(message,param1,param2);
    }

    public static void printLog(String appName, String trackingNo, Class logClass, String message, Object object, Level level) {
        getLogUtil().info("appName:{} trackingNo:{} className{} level:{} messasge:{} stackTrack:{}", appName, trackingNo, logClass, level.levelStr, message, JSONObject.toJSONString(object));
    }

    public static void printErrorLog(String appName, String trackingNo, String message, String url, Object request, Exception ex, Level level) {
        getLogUtil().error("appName:{} trackingNo:{} level:{} messasge:{} url:{} requestBody:{} stackTrack:{}", ex,appName, trackingNo, level.levelStr, message, url, JSONObject.toJSONString(request), JSONObject.toJSONString(ex));
    }
}
