package cn.freemud.service.adapter;

import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.CreateOrderType;
import cn.freemud.interceptor.ServiceException;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;

/**
 * 订单检查
 */
public interface OrderCheck {

    /***
     * 是否匹配
     * @param orderType {@link CreateOrderType}
     * @return
     */
    boolean support(int orderType);

    /**
     * 检查
     * @param vo
     * @param storeResponse
     */
    void check(CreateOrderVo vo, StoreResponse storeResponse) throws ServiceException;
}
