package cn.freemud.fuyou.service.processor;

import cn.freemud.enums.PayChannelEnum;
import cn.freemud.fuyou.controller.request.DiscountRequest;
import cn.freemud.fuyou.feign.ScoreFeignClient;
import cn.freemud.fuyou.feign.request.ScorePayRequest;
import cn.freemud.fuyou.feign.response.UpdateScoreResponse;
import cn.freemud.fuyou.service.PaymentService;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.ordercenter.enums.OrderSettlementType;
import com.freemud.application.sdk.api.ordercenter.request.OrderSettlementReq;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.OrderInfoReqs;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Component;

import static cn.freemud.management.util.ResponseCodeEnum.SUCCESS;

/**
 * 积分核销
 */
@Component
@Slf4j
public class IntegralEventProcessor extends AbstractProcessor {

    private final ScoreFeignClient scoreFeignClient;

    protected IntegralEventProcessor(OrderSdkService orderSdkService, PaymentService paymentService, ScoreFeignClient scoreFeignClient) {
        super(orderSdkService, paymentService);
        this.scoreFeignClient = scoreFeignClient;
    }


    @Override
    BaseResponse doProcess(DiscountRequest request) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(SUCCESS.code);
        final OrderInfoReqs order = getOrder(request.getOrderCode());

        ScorePayRequest scorePayRequest = new ScorePayRequest();
        scorePayRequest.setPartnerId(order.getPartnerId());
        scorePayRequest.setChangeScore(request.getScore().intValue());
        scorePayRequest.setMemberId(order.getUserId());
        scorePayRequest.setOrderId(order.getOrderCode());
        scorePayRequest.setOperationType(14);
        scorePayRequest.setIdempotencyBussinessType("5");
        scorePayRequest.setChangeScore(request.getScore().intValue());
        scorePayRequest.setIdempotencyBussinessId(request.getOrderCode());
        cn.freemud.base.entity.BaseResponse<UpdateScoreResponse> responseBaseResponse = scoreFeignClient.pay(scorePayRequest);
        log.info("scoreFeignClient.pay,order:{},response:{}", request.getOrderCode(), JSON.toJSONString(responseBaseResponse));
        if (ObjectUtils.notEqual(SUCCESS.code, responseBaseResponse.getCode())) {
            baseResponse.setCode(responseBaseResponse.getCode());
            baseResponse.setMessage(responseBaseResponse.getMessage());
        }
         return baseResponse;
    }


    @Override
    OrderSettlementReq getOrderSettlement(DiscountRequest request) {
        OrderInfoReqs orderInfoReqs = getOrder(request.getOrderCode());
        return buildOrderSettlement("富有积分兑换", OrderSettlementType.POINTS, true, orderInfoReqs, request);
    }


    @Override
    protected boolean postProcessors(DiscountRequest request) {
        return false;
    }

    @Override
    public Integer getEvent() {
        return PayChannelEnum.INTEGRAL.getCode();
    }
}
