package cn.freemud.fuyou.controller;

import cn.freemud.fuyou.controller.request.BaseRequest;
import cn.freemud.fuyou.controller.request.PayQueryRequest;
import cn.freemud.fuyou.service.PaymentService;
import com.freemud.application.sdk.api.ordercenter.response.BaseResponse;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/payment")
public class PaymentController {

    private final PaymentService paymentService;

    public PaymentController(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    /**
     * 支付方式：svc，现金，微信，支付宝
     * @param request
     * @return
     */
    @PostMapping("pay")
    public BaseResponse pay(@RequestBody @Validated BaseRequest request) {
        return paymentService.payment(request);
    }

    /**
     * 查询支付结果
     * @param request
     * @return
     */
    @PostMapping("paymentQuery")
    public BaseResponse paymentQuery(@RequestBody @Validated PayQueryRequest request) {
        return paymentService.paymentQuery(request);
    }






}
