package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import cn.freemud.service.impl.mcoffee.entity.*;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: MCoffeeShoppingCartController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/7/21 17:37
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RestController
@RequestMapping(value = "/shoppingCart/MCoffee", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "购物车 controller", tags = {"购物车管理接口"})
public class MCoffeeShoppingCartController {

    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    /**
     * 向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "addGoods")
    @PostMapping(value = "/addGoods")
    public BaseResponse addGoods(@Validated @LogParams @RequestBody MCoffeeAddGoodsRequestVo request) {
        return shoppingCartMCoffeeService.addGoods(request);
    }

    /**
     * 批量向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "batchAddGoods")
    @PostMapping(value = "/batchAddGoods")
    public BaseResponse addBatchGoods(@Validated @LogParams @RequestBody MCoffeeBatchAddGoodsRequestVo request) {
        return shoppingCartMCoffeeService.addBatchGoods(request);
    }

    /**
     * 修改购物车中商品数量
     */
    @ApiAnnotation(logMessage = "updateGoodsQty")
    @PostMapping(value = "/updateGoodsQty")
    public BaseResponse updateGoodsQty(@Validated @LogParams @RequestBody UpdateShoppingCartGoodsQtyRequestVo request) {
        return shoppingCartMCoffeeService.updateGoodsQty(request);
    }

    /**
     * 批量操作购物车商品接口
     */
    @ApiAnnotation(logMessage = "batchOperateGoods")
    @PostMapping(value = "/batchOperateGoods")
    public BaseResponse batchOperateShoppingCartGoods(@Validated @LogParams @RequestBody BatchOperateCartGoodsRequestVo request) {
        return shoppingCartMCoffeeService.batchOperateShoppingCartGoods(request);
    }

    /**
     * 批量修改购物车中商品数量
     */
    @ApiAnnotation(logMessage = "batchUpdateGoodsQty")
    @PostMapping(value = "/batchUpdateGoodsQty")
    public BaseResponse batchUpdateGoodsQty(@Validated @LogParams @RequestBody BatchUpdateGoodsQtyRequestVo request) {
        return shoppingCartMCoffeeService.batchUpdateGoodsQty(request);
    }

    /**
     * 向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "removeB3S1Coupon")
    @PostMapping(value = "/removeB3S1Coupon")
    public BaseResponse removeB3S1Coupon(@Validated @LogParams @RequestBody MCoffeeAddGoodsRequestVo request) {
        return shoppingCartMCoffeeService.removeB3S1Coupon(request);
    }


    @ApiAnnotation(logMessage = "getCartInfoByUser")
    @PostMapping(value = "/getCartInfoByUser")
    public BaseResponse getCartInfoByUser(@Validated @LogParams @RequestBody QueryCartInfoRequestVo requestVo){
        return shoppingCartMCoffeeService.getCartInfoByUser(requestVo);
    }


    /**
     * 修改或者新增购物车中商品
     */
    @ApiAnnotation(logMessage = "updateGoodsByCard")
    @PostMapping(value = "/card/updateGoods")
    public BaseResponse updateGoodsByCard(@Validated @LogParams @RequestBody MCoffeeCardAddVo request) {
        return shoppingCartMCoffeeService.updateGoodsByCard(request);
    }

    /**
     * 查询购物车信息
     */
    @ApiAnnotation(logMessage = "listCartGoods")
    @PostMapping(value = "/listCartGoods")
    public BaseResponse listCartGoods(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return shoppingCartMCoffeeService.getGoodsList(request);
    }

    /**
     * 查询购物车可使用优惠券
     */
    @ApiAnnotation(logMessage = "availableCoupon")
    @PostMapping(value = "/availableCoupon")
    public BaseResponse availableCoupon(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return shoppingCartMCoffeeService.availableCoupon(request);
    }

    /**
     * 清空购物车
     */
    @ApiAnnotation(logMessage = "clearCartGoods")
    @PostMapping(value = "/clearCartGoods")
    public BaseResponse clearCartGoods(@Validated @LogParams @RequestBody ShoppingCartClearRequestVo request) {
        return shoppingCartMCoffeeService.clear(request);
    }

    /**
     * 获取购物车均摊详情，点 "去支付" 时调用
     */
    @ApiAnnotation(logMessage = "getShoppingCartGoodsApportion")
    @PostMapping(value = "/getShoppingCartGoodsApportion")
    public BaseResponse getShoppingCartGoodsApportion(@Validated @LogParams @RequestBody GetShoppingCartGoodsApportionRequestVo requestVo) {
        return shoppingCartMCoffeeService.getShoppingCartGoods(requestVo);
    }


    /**
     * 切换门店购物车，校验商品或者复制原门店购物车到新门店
     */
    @ApiAnnotation(logMessage = "switchCartGoods")
    @PostMapping(value = "/switchCartGoods")
    public BaseResponse switchCartGoods(@Validated @LogParams @RequestBody SwitchShoppingCartRequestVo request) {
        return shoppingCartMCoffeeService.switchCartGoods(request);
    }

    /**
     * 再来一单
     */
    @ApiAnnotation(logMessage = "copyOrder")
    @PostMapping(value = "/copyOrder")
    public BaseResponse copyOrder(@Validated @LogParams @RequestBody CopyShoppingCartRequestVo request) {
        return shoppingCartMCoffeeService.copyOrder(request);
    }


}
