/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartNewServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/23 16:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ActivityCalculationDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.impl.ShoppingCartMealServiceImpl;
import cn.freemud.service.impl.mcoffee.ShoppingCartMCoffeeServiceImpl;
import cn.freemud.service.impl.mcoffee.calculation.CalculationServiceImpl;
import cn.freemud.service.impl.mcoffee.calculation.CouponDiscountCalculation;
import cn.freemud.service.impl.mcoffee.entity.MCoffeeAddGoodsRequestVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.shoppingcart.constant.MealClearOperationEnum;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartMCoffeeServiceTest {

    @Autowired
    private ShoppingCartMCoffeeServiceImpl shoppingCartMCoffeeService;

    @Autowired
    private CouponDiscountCalculation couponDiscountCalculation;

    @Test
    public void f1() {
        shoppingCartMCoffeeService.addGoods(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"channelType\":\"saas\",\"couponCode\":\"601153527093109\",\"couponType\":0,\"extra\":[],\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1628\",\"productComboList\":[{\"extra\":[],\"productMaterialList\":[],\"skuId\":\"204903200109635372\"}],\"productGroupList\":[],\"qty\":1,\"receiveId\":\"\",\"sessionId\":\"408cc5c5ce3967f849859d1cd11000ab1cf34729\",\"shopId\":\"99998\",\"skuId\":\"204906489299783199\",\"spuId\":\"204906489299783199\"}", MCoffeeAddGoodsRequestVo.class));
    }

    @Test
    public void f2() {
        shoppingCartMCoffeeService.updateGoodsQty(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"cartGoodsUid\":\"c9fd8e50-8dc9-48e2-a36e-bd6313ef81e9\",\"channelType\":\"saas\",\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"qty\":2,\"receiveId\":\"\",\"sessionId\":\"f3e238f5b30270ce4353695fe619fd6ddf9ce9ad\",\"shopId\":\"1450026\"}", UpdateShoppingCartGoodsQtyRequestVo.class));
    }

    @Test
    public void f3() {
        shoppingCartMCoffeeService.getGoodsList(JSON.parseObject("{\"appId\":\"wx6816a0b007741702\",\"buyType\":0,\"channelType\":\"saas\",\"couponCode\":\"\",\"isUseMonthCard\":1,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"1206\",\"receiveId\":\"\",\"sessionId\":\"b336cc00111c142d437236bfa69a688dfbc112c0\",\"shopId\":\"1450026\"}", ShoppingCartInfoRequestVo.class));
    }

    @Test
    public void f4() {
        couponDiscountCalculation.updateShoppingCartGoodsDiscount(
                JSON.parseObject("{\"apportionGoods\":[],\"couponDiscounts\":[],\"discounts\":[{\"activityCode\":\"227530982528469\",\"activityName\":\"买三赠一券_测试环境测试\",\"discount\":2500,\"extendType\":7,\"type\":35}],\"distributionFee\":0,\"goods\":[{\"actualGoodsNumber\":1,\"artNo\":\"100057810029630759\",\"cartGoodType\":0,\"cartGoodsUid\":\"1b8adc4d-1a77-4fd4-ab29-f7cb64fe8ced\",\"discountAmount\":2500,\"discounts\":[{\"activityCode\":\"227530982528469\",\"activityName\":\"买三赠一券_测试环境测试\",\"actualGoodsNumber\":1,\"discount\":2500,\"goodsId\":\"210821303631043841\",\"type\":35}],\"goodsId\":\"210821303631043841\",\"goodsQuantity\":1,\"nowPrice\":2500,\"originalPrice\":2500,\"realAmount\":0,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"9b38648d-d5fb-4d8e-8246-47c2753b0396\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"210886471963527432\",\"goodsQuantity\":1,\"nowPrice\":990,\"originalPrice\":990,\"realAmount\":990,\"smallMaterial\":[]},{\"cartGoodType\":0,\"cartGoodsUid\":\"bb81e777-da6a-41d2-89fe-49a3af139d9e\",\"discountAmount\":0,\"discounts\":[],\"goodsId\":\"9998\",\"goodsQuantity\":1,\"nowPrice\":0,\"originalPrice\":0,\"realAmount\":0,\"smallMaterial\":[]}],\"originalTotalAmount\":3490,\"stocks\":[],\"totalAmount\":990,\"totalDiscountAmount\":2500}", ActivityCalculationDiscountResponseDto.CalculationDiscountResult.class),
                JSON.parseArray("[{\"amount\":990,\"b3S1CouponGoodsInfo\":{\"cardCode\":\"227530982528469\",\"cardNo\":\"SCPQ04D51730C44FDDC039CC8F1510B55DC3\",\"isUseB3S1Coupon\":1},\"cartGoodsUid\":\"9b38648d-d5fb-4d8e-8246-47c2753b0396\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1624258436193,\"customerCode\":\"509835\",\"finalPrice\":990,\"goodsId\":\"210886471963527432\",\"goodsType\":9,\"isB3S1Coupon\":1,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"买三赠一\",\"originalAmount\":990,\"originalPrice\":990,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1623897302228.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"210886471963527432\",\"skuName\":\"买三赠一\",\"spuId\":\"210886471963527432\",\"spuName\":\"买三赠一\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false},{\"amount\":0,\"b3S1CouponGoodsInfo\":{\"cardCodeSet\":[\"227530982528469\"],\"isUseB3S1Coupon\":1},\"cartGoodsUid\":\"bb81e777-da6a-41d2-89fe-49a3af139d9e\",\"createTimeMili\":1624258436334,\"goodsId\":\"9998\",\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"originalAmount\":0,\"packPrice\":0,\"qty\":1,\"skuId\":\"9998\",\"spuId\":\"9998\",\"stockLimit\":false,\"weightType\":false},{\"amount\":2500,\"cartGoodsUid\":\"1b8adc4d-1a77-4fd4-ab29-f7cb64fe8ced\",\"classificationId\":\"\",\"classificationName\":\"\",\"createTimeMili\":1624258436356,\"customerCode\":\"510480\",\"finalPrice\":2500,\"goodsId\":\"210821303631043841\",\"goodsType\":5,\"isB3S1Coupon\":0,\"isB3S1CouponGoods\":0,\"isMonthCard\":0,\"isMonthCardGoods\":0,\"isSunnyCoupon\":0,\"isTableware\":false,\"memberDiscount\":100,\"name\":\"大杯燕麦拿铁\",\"originalAmount\":2500,\"originalPrice\":2500,\"packPrice\":0,\"pic\":\"https://picture.sandload.cn/1623810240405.png\",\"productComboList\":[],\"productGroupList\":[],\"qty\":1,\"riseSell\":1,\"skuId\":\"210821303631043841\",\"skuName\":\"大杯燕麦拿铁\",\"spuId\":\"210821303631043841\",\"spuName\":\"大杯燕麦拿铁\",\"stockLimit\":false,\"subName\":\"\",\"tax\":0.01,\"taxId\":\"\",\"unit\":\"\",\"weight\":0.0,\"weightType\":false}]", CartGoods.class),
                new ShoppingCartGoodsResponseVo());
    }

}
