/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: GetMenuResponseDto
 * @Package cn.freemud.entities.dto
 * @Description:
 * @author: liming.guo
 * @date: 2018/7/10 16:23
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.shoppingcart.domain;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@NoArgsConstructor
@Data
public class GetMenuResponseDto {


    private DataBean data;
    private Integer errcode;
    private String errmsg;

    @NoArgsConstructor
    @Data
    public static class DataBean {
        /**
         * 渠道 beiguo saas
         */
        private String channel;
        /**
         * 菜单 menu ID
         */
        private String mid;
        /**
         * 商品适用渠道  北国超市
         */
        private String name;
        /**
         * 商品节点
         */
        private RootNodeBean rootNode;

        @NoArgsConstructor
        @Data
        public static class RootNodeBean {
            /**
             * 子节点数量
             */
            private int childrenNum;
            /**
             * 是否有子节点
             */
            private int hasChild;
            private int level;
            /**
             * 菜单Id
             */
            private String menuId;
            private String name;
            private String nid;
            private Object product;
            private String productId;
            private String remark;
            private int sequence;
            private String type;
            private List<ChildrenBeanFirst> children;
            private List<?> labelNameList;

            @NoArgsConstructor
            @Data
            public static class ChildrenBeanFirst {
                private int childrenNum;
                private int hasChild;
                private int level;
                private String menuId;
                /**
                 * 分类名称
                 */
                private String name;
                /**
                 * 节点名称
                 */
                private String nid;
                private Object product;
                private String productId;
                private String remark;
                private int sequence;
                private String type;
                private List<ChildrenBeanSecond> children;
                private List<?> labelNameList;

                @NoArgsConstructor
                @Data
                public static class ChildrenBeanSecond {

                    private int childrenNum;
                    private int hasChild;
                    private int level;
                    private String menuId;
                    private String name;
                    private String nid;
                    private ProductBean product;
                    private String productId;
                    private String remark;
                    private int sequence;
                    private String type;
                    private List<?> children;
                    private List<?> labelNameList;

                    @NoArgsConstructor
                    @Data
                    public static class ProductBean {

                        private String barcode;
                        private String brandId;
                        private String brandName;
                        private String category;
                        private String categoryName;
                        private String companyId;
                        private String customerCode;
                        /**
                         * 最终价格 单位分
                         */
                        private Long finalPrice;
                        /**
                         * 是否是SKU商品  1是0否
                         */
                        private Integer isSkuProduct;
                        private String name;
                        /**
                         * 原始价格 单位分
                         */
                        private Long originalPrice;
                        /**
                         * 包装费 单位分
                         */
                        private Long packPrice;

                        private String picture;
                        private String pid;
                        private Integer pknumber;
                        private String productionLocation;
                        private String remark;
                        private Integer saleCount;
                        private String sellTimeName;
                        private Integer sequence;
                        private String sourceChannel;
                        private String specification;
                        private Integer status;
                        private Integer stock;
                        private Integer stockLimit;
                        /**
                         * type=10 多规格  type=1 单规格
                         */
                        private int type;
                        /**
                         * 是否是称重商品 1、表示为称重
                         */
                        private Integer weightType;
                        private String unit;
                        private int updateStatus;
                        private boolean valid;
                        private int version;
                        private List<ProductLabelNameBean> labelNames;
                        private List<ProductAttributeGroupListBean> productAttributeGroupList;
                        private List<ProductPictureListBean> productPictureList;
                        private List<?> productSpecification;
                        private List<?> sellTimeList;
                        private List<?> specificationList;
                        //SKU
                        private List<SkuProductBean> skuList;
                        //规格信息
                        private List<SpecificationGroupBean> specificationGroupList;
                        //Sku 规格 如果 当前是sku 则有值
                        private List<SkuProductBean.SkuSpecValue> skuSpecValues;
                        /**
                         * 套餐商品固定搭配子商品列表
                         */
                        private List<ProductComboType> productComboList;
                        /**
                         * 可选商品列表
                         */
                        private List<ProductGroupType> productGroupList;
                        @NoArgsConstructor
                        @Data
                        public static class SkuProductBean {
                            private Long finalPrice;
                            private Long originalPrice;
                            private String productName;
                            private Integer productType;
                            private Integer sequence;
                            private String skuCode;
                            private String skuId;

                            private Integer status;
                            //以下两个字段 1.5.4新加
                            private Integer stockLimit;
                            private Integer stockQty;
                            //sku商品包装费 1.5.4新加
                            private Long packPrice ;
                            private List<SkuSpecValue> skuSpecValues;

                            @NoArgsConstructor
                            @Data
                            public static class SkuSpecValue {
                                private String productId;
                                private Integer sequence;
                                private String specId;
                                private String specName;
                                private String specValue;
                                private String specValueId;
                            }
                        }

                        @NoArgsConstructor
                        @Data
                        public static class SpecificationGroupBean {
                            private String partnerId;
                            private Integer sequence;
                            private String specId;
                            private String specName;
                            private List<SpecValueVo> specValueVos;

                            @NoArgsConstructor
                            @Data
                            public static class SpecValueVo {
                                private Integer sequence;
                                private String specId;
                                private String specValue;
                                private String specValueId;
                            }
                        }

                        @NoArgsConstructor
                        @Data
                        public static class ProductLabelNameBean {
                            private String id;
                            private String name;
                            private String partnerId;
                            List<?> productList;
                            private String storeId;
                            private String type;
                        }

                        @NoArgsConstructor
                        @Data
                        public static class ProductAttributeGroupListBean {
                            /**
                             * attributeName : 加料
                             * attributeType : 1
                             * attributeValues : [{"attributeValue":"","id":0,"price":0,"sequence":0,"status":0}]
                             */

                            /**
                             * 属性名称
                             */
                            private String attributeName;
                            /**
                             * 属性类型
                             */
                            private Integer attributeType;
                            /**
                             * 属性详细信息
                             */
                            private List<AttributeValueBean> attributeValues;

                            @NoArgsConstructor
                            @Data
                            public static class AttributeValueBean {
                                /**
                                 * attributeValue :
                                 * id : 0
                                 * price : 0
                                 * sequence : 0
                                 * status : 0
                                 */
                                /**
                                 * 属性值
                                 */
                                private String attributeId;

                                private String attributeValue;
                                /**
                                 * 属性ID
                                 */
                                private Long id;
                                /**
                                 *
                                 */
                                private Long price;
                                private Integer sequence;
                                private Integer status;
                            }
                        }

                        @NoArgsConstructor
                        @Data
                        public static class ProductPictureListBean {
                            /**
                             * pictureId : 107901339444445753
                             * productId : 107901318808470072
                             * sequence : 0
                             * type : default
                             * url : http://ojcpa0rpt.bkt.clouddn.com/xianfengfruit_DishPool_default_30b5f0ca-399a-4be3-9063-12a3d2622a38_1513952518.jpg
                             */

                            private String pictureId;
                            private String productId;
                            private String sequence;
                            private String type;
                            private String url;
                        }

                        @NoArgsConstructor
                        @Data
                        public static class ProductComboType {
                            /**
                             * 商品ID
                             */
                            private String productId;
                            /**
                             * 商品名称
                             */
                            private String productName;
                            //
                            protected Integer productType;
                            /**
                             * 第三方商品编码
                             */
                            private String customerCode;
                            /**
                             * 标准售价
                             */
                            private Integer originalPrice;
                            /**
                             * 最终售价
                             */
                            protected Integer finalPrice;
                            /**
                             * 包装费
                             */
                            protected Integer packPrice;
                            /**
                             * 商品后台分类编码
                             */
                            protected String category;
                            /**
                             * 商品后台分类
                             */
                            protected String categoryName;
                            /**
                             * 商品默认图片
                             */
                            private String picture;
                            //
                            private Integer status;
                            /**
                             * 是否设置库存
                             */
                            private Integer stockLimit;
                            /**
                             * 规格
                             */
                            protected String specification;
                            /**
                             * 单位
                             */
                            protected String unit;
                            //
                            protected String barcode;
                            //扩展字段
                            protected String options;
                            /**
                             * 商品Code
                             */
                            protected String productCode;
                            private Integer quantity;
                            private Integer sequence;
                        }

                        @NoArgsConstructor
                        @Data
                        public static class ProductGroupType {
                            /**
                             * 商品组ID
                             */
                            private String pgid;
                            /**
                             * 扩展字段
                             */
                            private String options;

                            /**
                             * 商品组名
                             */
                            private String name;

                            /**
                             * 商品组规则-是否必选
                             */
                            private Integer must;

                            /**
                             * 商品组规则-选择的最小数量
                             */
                            private Integer minNumber;

                            /**
                             * 商品组规则-选择的最大数量
                             */
                            private Integer maxNumber;

                            /**
                             * 商品组备注
                             */
                            private String remark;

                            /**
                             * 商品组详情
                             */
                            private List<GroupDetailType> groupDetail;


                            @NoArgsConstructor
                            @Data
                            public static class GroupDetailType{
                                /**
                                 * 商品组ID
                                 */
                                private String groupId;

                                /**
                                 * 是否默认商品，1是0否
                                 */
                                private Integer isDefault;

                                /**
                                 * 商品ID
                                 */
                                private String productId;

                                /**
                                 * 商品名称
                                 */
                                private String productName;

                                /**
                                 * 第三方商品编码
                                 */
                                private String customerCode;

                                /**
                                 * 标准售价
                                 */
                                private Integer productPrice;

                                /**
                                 * 最终售价
                                 */
                                protected Integer productFinalPrice;

                                /**
                                 * 最终售价
                                 */
                                protected Integer markUpPrice;

                                /**
                                 * 商品后台分类编码
                                 */
                                protected String category;

                                /**
                                 * 商品后台分类
                                 */
                                protected String categoryName;

                                /**
                                 * 商品默认图片
                                 */
                                private String picture;

                                /**
                                 * 商品默认图片
                                 */
                                private Integer status;

                                /**
                                 * 是否设置库存
                                 */
                                private Integer stockLimit;

                                /**
                                 * 规格
                                 */
                                protected String specification;

                                protected Integer productType;

                                /**
                                 * 单位
                                 */
                                protected String unit;

                                /**
                                 * 扩展字段
                                 */
                                protected String options;
                                /**
                                 * 商品Code
                                 */
                                protected String productCode;
                            }

                        }
                    }
                }
            }
        }
    }
}
