package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.PurchasePaidRequestDto;
import cn.freemud.entities.dto.QueryOrderByIdResponseDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.service.thirdparty.CustomerApplicationClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.sdk.api.assortment.order.enums.OldOrderAccountType;
import com.freemud.sdk.api.assortment.order.enums.OrderSdkType;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrderByIdResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CustomerClientTest
 * @Package cn.freemud.service
 * @Description:
 * @author: yuhao.chi
 * @date: 2019/5/30 15:23
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class CustomerClientTest {

    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private CustomerApplicationClient customerApplicationClient;


    @Test
    public void getDeliveryAddressORStoreTest() {
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId("14593125243582064200085");
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryOrderByIdResponseDto queryOrderByIdResponseDto = jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
        QueryOrdersResponseDto.DataBean.OrderBean orderBean = queryOrderByIdResponseDto.getData();

        if (CollectionUtils.isNotEmpty(orderBean.getAccountList())) {
            for (QueryOrdersResponseDto.DataBean.OrderBean.AccountBean accountBean : orderBean.getAccountList()) {
                if (OldOrderAccountType.CARD_ORIGINAL_AMOUNT.getCode().equals(accountBean.getType())) {
                    this.activateMemberCard(orderBean.getCompanyId(), "515591395407699646", orderBean.getOid(), orderBean.getUserId());
                    break;
                }
            }
        }
    }

    private void activateMemberCard(String partnerId, String ruleId, String oid, String userId) {
        PurchasePaidRequestDto purchasePaidRequestDto = new PurchasePaidRequestDto();
        purchasePaidRequestDto.setPartnerId(partnerId);
        purchasePaidRequestDto.setOperatorType(1);
        purchasePaidRequestDto.setRuleId(ruleId);
        purchasePaidRequestDto.setOrderId(oid);
        purchasePaidRequestDto.setMemberId(userId);
        // 尝试三次开通会员卡，中途成功则跳出
        int count = 3;
        for (int i = 0; i < count; i++) {
            BaseResponse baseResponse = customerApplicationClient.purchasePaid(purchasePaidRequestDto);
            // 不以响应码为判断是否开通会员卡成功的标准
            if (baseResponse != null && "SUCCESS".equals(baseResponse.getResult())) {
                break;
            }
        }
    }

}
