package cn.freemud.service.impl;

import cn.freemud.adapter.BigDataAdapter;
import cn.freemud.adapter.MemberAdapter;
import cn.freemud.adapter.MessageNoticeAdapter;
import cn.freemud.adapter.UserAdapter;
import cn.freemud.base.constant.Version;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.util.MD5Util;
import cn.freemud.constant.ApplicationConstant;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.UserInfoKeyConstant;
import cn.freemud.entities.db.Partner;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.user.UserInfoDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.*;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.manager.OpenPlatformWxappPluginBindManager;
import cn.freemud.manager.PartnerManager;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.UserService;
import cn.freemud.service.thirdparty.*;
import cn.freemud.utils.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerMerchant;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformWxapp;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerMerchantManager;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappManager;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.net.URLEncoder;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @author liming.guo
 * @date 2018/05/11
 */
@Service
@Slf4j
public class UserServiceImpl implements UserService {
    private static Gson gson = new Gson();
    @Autowired
    private UserAdapter userAdapter;
    @Autowired
    private RedisCache redisCache;

    /**
     * 校验用户是否登录
     */
    public void checkUserLogin(String sessionId) {
        Map<String, Object> userInfoMap = this.getUserInfoMapBySessionId(sessionId);
        if (userInfoMap == null || userInfoMap.size() <= 0 || userInfoMap.get(UserInfoKeyConstant.MEMBER_ID) == null) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
    }
    /**
     * 校验用户是否登录
     */
    public boolean checkUserLoginFlag(String sessionId) {
        Map<String, Object> userInfoMap = this.getUserInfoMapBySessionId(sessionId);
        log.info("submit userInfoMap:{}", gson.toJson(userInfoMap));
        if (userInfoMap == null || userInfoMap.size() <= 0 || userInfoMap.get(UserInfoKeyConstant.MEMBER_ID) == null) {
            return false;
        }
        return true;
    }

    /**
     * 获取缓存用户信息
     */
    @Override
    public Map<String, Object> getUserInfoMapBySessionId(String sessionId) {
        String redisKey = RedisKeyConstant.SAAS_USER_INFO_SESSIONID_KEY_PREFIX + sessionId;
        Map<String, Object> map;
        try {
            map = redisCache.getValue(redisKey);
        }catch (Exception e){
            map = redisCache.getValue(redisKey);
        }
        return map;
    }

    /**
     * 获取缓存用户信息
     *
     * @param sessionId
     * @return
     */
    @Override
    public UserLoginInfoDto getUserLoginInfoBySessionId(String sessionId) {
        checkUserLogin(sessionId);

        String redisKey = RedisKeyConstant.SAAS_USER_INFO_SESSIONID_KEY_PREFIX + sessionId;
        Map<String, Object> map = redisCache.getValue(redisKey);
        return userAdapter.getUserLoginInfoDto(map);
    }
}
