package cn.freemud.entities.db;

import cn.freemud.comm.entity.BaseEntity;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.util.Date;

/**
 * 商户小程序
 *
 * @author liming.guo
 * @date 2018/05/10
 */
@Data
public class PartnerWxapp extends BaseEntity {

    private Long id;
    /**
     * 商户ID
     */
    private String partnerId;
    /**
     * 支付使用商户ID
     */
    private String payPartnerId;
    /**
     * 支付使用门店ID
     */
    private String payStoreId;
    /**
     * 小程序appid
     */
    private String wxAppid;
    /**
     * 小程序appsecret
     */
    private String wxAppsecret;
    /**
     * 小程序名称
     */
    private String wxAppname;
    /**
     * 加密后appid 内部及传输使用
     */
    private String appid;
    /**
     * 登录email
     */
    private String email;
    /**
     * 登录密码
     */
    private String emailPassward;
    /**
     * 小程序开通状态  WxappStatus
     */
    private Long status;

    private Date gmtCreated;

    private Date gmtModified;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
