package cn.freemud.service.thirdparty;

import cn.freemud.annotations.IgnoreFeignLogAnnotation;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.constant.ResponseCodeKeyConstant;
import cn.freemud.entities.vo.QueryDeliveryDistanceRequest;
import cn.freemud.entities.vo.QueryDeliveryDistanceResponseVo;
import cn.freemud.entities.vo.QueryDeliveryTemplateRequestVo;
import cn.freemud.entities.vo.QueryDeliveryTemplateResponseVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = "DELIVERYCENTER", url = "${delivery.center.feign.Url}")
public interface DeliveryFeiginClient {

    @PostMapping("/delivery/queryDeliveryTemplate")
    @IgnoreFeignLogAnnotation(logMessage = "queryDeliveryTemplate",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryDeliveryTemplateResponseVo queryDeliveryTemplate(@RequestBody QueryDeliveryTemplateRequestVo queryDeliveryTemplateRequestVo);

    @PostMapping("/tools/routePlanner")
    @IgnoreFeignLogAnnotation(logMessage = "queryDeliveryDistance",excludeStatusCodes = {ResponseCodeConstant.RESPONSE_SUCCESS_STR},statusCodeFieldName= ResponseCodeKeyConstant.STATUS_CODE,messageFieldName=ResponseCodeKeyConstant.MSG)
    QueryDeliveryDistanceResponseVo queryDeliveryDistance(@RequestBody QueryDeliveryDistanceRequest queryDeliveryTemplateRequestVo);
}
