package cn.freemud.entities.dto.console;

import lombok.Data;

/**
 * @author : xh.Z
 * @email : fisherman0510@163.com
 * @Date : 2021/7/22 下午3:12
 * @description :
 */
@Data
public class DeliveryInfoDTO {

    /**
     * 每增加公里（单位米）
     */
    private String addRange;

    /**
     * 每增加公里增加配送费（单位分）
     */
    private Integer addRangeAmount;

    /**
     * 基础配送费（分）
     */
    private Integer deliveryAmount;

    /**
     * 配送方式:1-三方物流配送、2-商家自配送
     */
    private Integer deliveryMethod;

    /**
     * 配送半径
     */
    private Integer deliveryRadius;

    /**
     * 基础配送距离（单位米）
     */
    private String deliveryRange;

    /**
     * 手绘经纬度集合
     */
    private String deliveryScope;

    /**
     * 外卖起送条件（1:杯数，2:金额）
     */
    private Integer deliveryType;

    /**
     * 起送杯数
     */
    private Integer freeDeliveryCup;

    /**
     * 起送价格（单位分）
     */
    private Integer freeDeliveryPrice;

    /**
     * 所属商户号
     */
    private String partnerId;

    /**
     * 配送范围类型 1 自定义 2 半径
     */
    private Integer scopeConfig;

    /**
     * 门店计算好的 最终配送费价格, 包含阶梯算价之后 （单位分）
     */
    private Integer finalDeliveryAmount;


    /**
     * 额外拓展属性 json
     * @see cn.freemud.entities.dto.console.DeliveryInfoExpandFieldDTO
     */
    private DeliveryInfoExpandFieldDTO expandFields;


}
