/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderItemResp
 * @Package com.freemud.application.sdk.api.ordercenter.response.orderInfo
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/2 17:29
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.application.sdk.api.ordercenter.response.orderInfo;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderItemResp {

    //商户号
    private String partnerId;

    //商品编号，商品服务唯一标识，SKU
    private String productId;

    //默认false，ignoreInOrderClose=false表示这个明细退完才能关单;ignoreInOrderClose=true表示这个明细没有退，但是该订单其他明细退完了就关单了
    private Boolean ignoreInOrderClose = false;

    //三方商品ID、SKU 商品服务唯一
    private String thirdProductId;

    //商品货号，商品服务可重复
    private String productCode;

    //订单商品明细ID
    private Long id;

    //父商品编号，主要用户组合商品
    private String parentProductId;

    //订单编号
    private String orderCode;

    //商品名称
    private String productName;

    //商品英文名称
    private String productForeignName;

    //商品序号
    private Integer productSeq;

    //商品规格编号
    private String productSpec;

    //商品规格名称
    private String productSpecName;
    //商品规格英文名称
    private String productForeignSpecName;


    //商品UPC码
    private String productUpc;

    //购买数量
    private Integer productQuantity;

    //产品单位如份、杯
    private String productUnit;

    //商品单价
    private BigDecimal productPrice;

    //用户在界面上看到的支付金额，单位分
    private BigDecimal settlementPrice;

    //销售价格
    private BigDecimal salePrice;

    //优惠分摊金额
    private BigDecimal productSharePrice;

    //产品图片URL
    private String productPicUrl;

    //商品属性
    private String productProperty;

    //商品属性
    private String productForeignProperty;

    //重量
    private BigDecimal weight;

    //重量单位
    private Byte productWeightUnit;

    // @ApiModelProperty(value = CanRefundType.API_DESC)
    private Boolean canRefund = true;

    //销售类型或营销活动类型 1普通订单 2秒杀订单 3推广活动 4拼单订单
    private Byte marketingType;

    //活动ID
    private String marketingCode;

    //备注
    private String note;

    //商品类型 --6
    private Integer productType;

    //商品明细扩展对象
    private String extInfo;

    //加购人ID
    private String userId;

    //加购人openId
    private String openId;

    //加购人昵称
    private String nickName;

    //加购人头像
    private String photoUrl;

    //加购人包装费
    private Long packPrice;

}
