package com.freemud.application.sdk.api.ordercenter.enums;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: NewOrderStatus
 * @Package com.freemud.application.sdk.api.ordercenter.enums
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/26 16:19
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public enum NewOrderStatus {

    PENDING_PAYMENT(1, "待支付"),
    PLACE_AN_ORDER(2, "下单"),
    ACCEPTED(3, "已接单"),
    PRODUCED(4, "制作完成(待发货)"),
    DELIVERING(5, "配送中"),
    COMPLETE(6, "已完成"),
    CLOSED(7, "已关闭");


    private Integer index;
    private String name;

    NewOrderStatus(Integer index, String name) {
        this.index = index;
        this.name = name;
    }

    public static NewOrderStatus getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (NewOrderStatus orderStatus : values()) {
            if (orderStatus.getIndex().equals(code)) {
                return orderStatus;
            }
        }
        return null;
    }

    public Integer getIndex() {
        return index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
