package cn.freemud.service;

import cn.freemud.OrderApplication;
import cn.freemud.base.constant.Version;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.CancelDeliveryRequest;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.management.entities.dto.request.order.*;
import cn.freemud.entities.dto.delivery.CancelDeliveryResponseDto;
import cn.freemud.management.entities.dto.response.coupon.McdNetBatchQueryResponse;
import cn.freemud.management.thirdparty.CouponOfflineMCCafeClient;
import cn.freemud.service.mccafe.thirdparty.DeliveryFeiginMCCafeClient;
import cn.freemud.utils.AppLogUtil;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponBaseResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponQueryResponse;
import com.freemud.application.sdk.api.couponcenter.offline.response.CouponRedeemResponse;
import cn.freemud.enums.CouponReqTypeEnum;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.request.UpdateDownstreamOrderCodeReq;
import com.freemud.application.sdk.api.ordercenter.response.OrderBaseResp;
import com.freemud.application.sdk.api.ordercenter.service.OrderSdkService;
import org.apache.commons.collections4.CollectionUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = OrderApplication.class)
public class CouponActivityServiceTest {

    @Autowired
    private CouponOfflineMCCafeClient offlineMCCafeClient;

    @Autowired
    private DeliveryFeiginMCCafeClient deliveryFeiginMCCafeClient;

    @Autowired
    private OrderSdkService orderSdkService;

    @Test
    public void redeemTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.REDEEM.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        // 订单号
        couponCodeVerificationDto.setTrans_id("testRedeem0729011");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        List<MCCafeTransactionVo> transactions = new ArrayList<>();
        MCCafeTransactionVo mcCafeTransactionVo = new MCCafeTransactionVo();
        mcCafeTransactionVo.setCode("227086461372848");
        List<MCCafeProductRedeemVo> products = new ArrayList<>();
        MCCafeProductRedeemVo mcCafeProductRedeemVo = new MCCafeProductRedeemVo();
        mcCafeProductRedeemVo.setConsume_num(1);
        mcCafeProductRedeemVo.setPid("100057810020870000");
        mcCafeProductRedeemVo.setCustomer_code("11");
        mcCafeProductRedeemVo.setKeyProductCode("11");
        mcCafeProductRedeemVo.setSeq(1);
        products.add(mcCafeProductRedeemVo);
        mcCafeTransactionVo.setProducts(products);
        transactions.add(mcCafeTransactionVo);
        couponCodeVerificationDto.setTransactions(transactions);
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponRedeemResponse couponCodeResponseDto = offlineMCCafeClient.redeem(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void cancelRedeemTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.CANCEL_REDEEM.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        // 订单号
        couponCodeVerificationDto.setTrans_id("testRedeem0729009");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        List<MCCafeTransactionVo> transactions = new ArrayList<>();
        MCCafeTransactionVo mcCafeTransactionVo = new MCCafeTransactionVo();
        mcCafeTransactionVo.setCode("297330216254368");
        List<MCCafeProductRedeemVo> products = new ArrayList<>();
        MCCafeProductRedeemVo mcCafeProductRedeemVo = new MCCafeProductRedeemVo();
        mcCafeProductRedeemVo.setConsume_num(1);
        mcCafeProductRedeemVo.setPid("100057810020870000");
        mcCafeProductRedeemVo.setCustomer_code("11");
        mcCafeProductRedeemVo.setKeyProductCode("11");
        mcCafeProductRedeemVo.setSeq(1);
        products.add(mcCafeProductRedeemVo);
        mcCafeTransactionVo.setProducts(products);
        transactions.add(mcCafeTransactionVo);
        couponCodeVerificationDto.setTransactions(transactions);
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponRedeemResponse couponCodeResponseDto = offlineMCCafeClient.cancelRedeem(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void queryTest() {
        MCCafeCouponRequest couponCodeVerificationDto = new MCCafeCouponRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqtype(CouponReqTypeEnum.QUERY.getCode());
        couponCodeVerificationDto.setPartnerId(1206);
        couponCodeVerificationDto.setStore_id("khl-12345");
        couponCodeVerificationDto.setStation_id("1");
        couponCodeVerificationDto.setOperator_id("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setCoupon("297933023371288");
        couponCodeVerificationDto.setSign("skip");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponQueryResponse couponQueryResponse = offlineMCCafeClient.query(couponCodeVerificationDto);
        System.out.println(JSON.toJSONString(couponQueryResponse));
    }

    @Test
    public void lockTest() {
        MCCafeCouponLockRequest couponCodeVerificationDto = new MCCafeCouponLockRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqType(89);
        couponCodeVerificationDto.setPartnerId("1206");
        couponCodeVerificationDto.setStoreId("99992");
        // 订单号
        couponCodeVerificationDto.setTransId("18579931215294931300006");
        couponCodeVerificationDto.setOfferId("224368493682038");
        couponCodeVerificationDto.setCoupon("224368493682038");
        couponCodeVerificationDto.setNumber("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setOperatorId("1");
        couponCodeVerificationDto.setStationId("1");
        couponCodeVerificationDto.setSign("ss");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponBaseResponse couponCodeResponseDto = offlineMCCafeClient.lock(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void unlockTest() {
        MCCafeCouponLockRequest couponCodeVerificationDto = new MCCafeCouponLockRequest();
        couponCodeVerificationDto.setVer(Integer.valueOf(Version.VERSION_1));
        couponCodeVerificationDto.setReqType(90);
        couponCodeVerificationDto.setPartnerId("1206");
        couponCodeVerificationDto.setStoreId("khl-12345");
        // 订单号
        couponCodeVerificationDto.setTransId("00000002");
        couponCodeVerificationDto.setOfferId("281168656683188");
        couponCodeVerificationDto.setCoupon("281168656683188");
        couponCodeVerificationDto.setNumber("1");
        couponCodeVerificationDto.setChannel("mocoffee_wx");
        couponCodeVerificationDto.setOperatorId("1");
        couponCodeVerificationDto.setStationId("1");
        couponCodeVerificationDto.setSign("ss");

        System.out.println(JSON.toJSONString(couponCodeVerificationDto));
        CouponBaseResponse couponCodeResponseDto = offlineMCCafeClient.unlock(couponCodeVerificationDto);
        System.out.println(couponCodeResponseDto);
    }

    @Test
    public void cancelDeliveryTest() {
        CancelDeliveryRequest cancelDeliveryRequest = CancelDeliveryRequest.builder()
                .displayOrderId("1450026-10/07/2020-6667")
                .orderId("77777*2020-08-06#66667")
                .orderCancelCode("4")
                .orderCancelDescription("用户申请退款")
                .storeId("99992")
                .deliveryId("742092795987337216f5")
                .reviewId("77777*2020-08-06#66")
                .receiveOrderType("receivedOrder").build();
        CancelDeliveryResponseDto deliveryBaseResponse = deliveryFeiginMCCafeClient.cancelRequest(cancelDeliveryRequest);

        System.out.println(JSON.toJSONString(cancelDeliveryRequest));
        System.out.println(JSON.toJSONString(deliveryBaseResponse));
    }

    @Test
    public void updateDownstreamThirdOrderCodeTest() {
        UpdateDownstreamOrderCodeReq updateDownstreamOrderCodeReq = new UpdateDownstreamOrderCodeReq();
        updateDownstreamOrderCodeReq.setOrderCode("18551836670069965100006");
        OrderBaseResp baseResponse = orderSdkService.updateDownstreamThirdOrderCode(updateDownstreamOrderCodeReq, LogThreadLocal.getTrackingNo());

        LinkedHashMap<String, String> linkedHashMap = (LinkedHashMap) baseResponse.getResult();

        System.out.println(linkedHashMap.get("downstreamThirdOrderCode"));
    }

    @Test
    public void batchQueryTest() {

        MCCafeCouponRequest mcCafeCouponRequest = MCCafeCouponRequest.builder()
                .ver(Integer.valueOf(Version.VERSION_1))
                .reqtype(CouponReqTypeEnum.QUERY.getCode())
                .partnerId(1206)
                .store_id("khl-12345")
                .station_id("1")
                .operator_id("1")
                .channel("mocoffee_wx")
                .couponlist(Arrays.asList(new MCCafeCouponVo("229382080857268"),new MCCafeCouponVo("212791286228799"),new MCCafeCouponVo("224368493682038")))
                .sign("skip")
                .build();

        System.out.println(JSON.toJSONString(mcCafeCouponRequest));
        McdNetBatchQueryResponse mcdNetBatchQueryResponse = offlineMCCafeClient.batchQuery(mcCafeCouponRequest);
        System.out.println(JSON.toJSONString(mcdNetBatchQueryResponse));
        if (mcdNetBatchQueryResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS.equals(mcdNetBatchQueryResponse.getStatusCode())
                || CollectionUtils.isEmpty(mcdNetBatchQueryResponse.getCouponlist())) {
            AppLogUtil.infoLog("部分优惠券当前不可用", mcCafeCouponRequest, mcdNetBatchQueryResponse);
            throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT, "部分优惠券当前不可用");
        } else {
            mcdNetBatchQueryResponse.getCouponlist().forEach(o -> {
                if(!ResponseCodeConstant.RESPONSE_SUCCESS.equals(o.getStatusCode())) {
                    if(o.getCodeInfo() != null) {
                        AppLogUtil.infoLog(o.getCodeInfo().getAct_name()+"当前不可用", mcCafeCouponRequest, mcdNetBatchQueryResponse);
                        throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT, o.getCodeInfo().getAct_name()+"当前不可用");
                    } else {
                        AppLogUtil.infoLog("部分优惠券暂时不可用", mcCafeCouponRequest, mcdNetBatchQueryResponse);
                        throw new ServiceException(ResponseResult.COUPON_SHOP_NOTSUPPORT, "部分优惠券暂时不可用");
                    }
                }
            });
        }
    }
}