/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: CustomerExtendClient
 * @Package cn.freemud.service.thirdparty
 * @Description:
 * @author: song.cai
 * @date: 2019/2/20 16:42
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service.thirdparty;

import com.freemud.application.sdk.api.ordercenter.annotation.LogIgnoreFeign;
import cn.freemud.entities.dto.GetMemberCouponListRequestDto;
import cn.freemud.entities.dto.GetMemberCouponListResponseDto;
import cn.freemud.entities.dto.user.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.List;

@FeignClient(name = "customer-extend-service", url = "${saas.customerextendclient.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface CustomerExtendClient {
    /**
     * 会员优惠券列表
     */
    @LogIgnoreFeign(logMessage="getMemberCouponListRequestDto")
    @PostMapping(value = "/customerextendservice/coupon/getCoupons")
    GetMemberCouponListResponseDto getMemberCouponListRequestDto(@RequestBody GetMemberCouponListRequestDto getMemberCouponListRequestDto);

    @LogIgnoreFeign(logMessage="sendCouponForqujia")
    @PostMapping(value = "/customerextendservice/qujia/receiveCard")
    SendCouponForqujiaDtoResponseDto sendCouponForqujia(@RequestBody SendCouponForqujiaRequestDto request);

//    @LogIgnoreFeign(logMessage="b2bReceiveCard")
//    @PostMapping(value = "/customerextendservice/qujia/b2breceiveCard")
//    B2bReceiveCardResponseDto b2bReceiveCard(@RequestBody B2bReceiveCardRequestDto request);

    /**
     * 校验request里面的券 是否正常
     * @param request
     * @return 如果和request 返回券一致 表示正常
     * 这个接口 无力吐槽
     */
    @LogIgnoreFeign(logMessage="getMemberCouponCodes")
    @PostMapping(value = "/customerextendservice/coupon/getMemberCouponCodes")
    UserBaseResponsDTO<List<String>> getMemberCouponCodes(@RequestBody UserCouponCheckRequest request);

}
