/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartNewServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: song.cai
 * @date: 2019/1/23 16:56
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package cn.freemud.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.service.impl.ShoppingCartNewServiceImpl;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.core.SpringVersion;
import org.springframework.test.context.junit4.SpringRunner;

@Slf4j
@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class ShoppingCartNewServiceTest {

    @Autowired
    private ShoppingCartNewServiceImpl shoppingCartNewService;

    @Test
    public void addGoodsByCard() {
        AddGoodsByWeixinCardRequestVo requestVo = new AddGoodsByWeixinCardRequestVo();
        requestVo.setSessionId("1374933477d9ae3f68d51fe9cf355015eb5cb325");
        requestVo.setPartnerId("1864");
        requestVo.setShopId("1810291131");
        requestVo.setAppId("wxb78fb7c6218cb52c");
        requestVo.setCardId("pKs8D1dP8JiEWhzsuu29v-L-Xyew");
        requestVo.setEncryptCode("U07nEpq1aYHLSkLqI6m1IjUezTvRhfBdz+ZY1iOZ09SxAglRkpS4D98HFLrYk9Sd");
        requestVo.setCouponType(0);
        BaseResponse baseResponse = shoppingCartNewService.addGoodsByCard(requestVo);
        log.debug("baseResponse : " + baseResponse);
    }

    @Test
    public void addGoods() {
        String requestJson = "{\"appId\":\"wxb78fb7c6218cb52c\",\"categoryName\":\"库存\",\"orderType\":1,\"partnerId\":\"1864\",\"productComboList\":[],\"productGroupList\":[],\"sessionId\":\"9f4da5564ee1b7d0c72a29ad854e58eb9be68c05\",\"shopId\":\"999999998\",\"skuId\":\"\",\"spuId\":\"152352063746106644\"}";
        AddShoppingCartGoodsRequestVo addShoppingCartGoodsRequestVo = JSONObject.parseObject(requestJson, AddShoppingCartGoodsRequestVo.class);
        BaseResponse response = shoppingCartNewService.addGoods(addShoppingCartGoodsRequestVo);
        log.debug("shoppingCartGoodsResponseVo==" + JSONObject.toJSONString(response));

    }

    @Test
    public void updateGoodsQty() {
        String requestJson = "{\"appId\":\"wxb78fb7c6218cb52c\",\"cartGoodsUid\":\"4761ad89-ddf6-4063-bcfd-e59b5a42be37\",\"orderType\":1,\"partnerId\":\"1864\",\"qty\":5,\"sessionId\":\"9f4da5564ee1b7d0c72a29ad854e58eb9be68c05\",\"shopId\":\"999999998\"}";
        UpdateShoppingCartGoodsQtyRequestVo updateShoppingCartGoodsQtyRequestVo = JSONObject.parseObject(requestJson, UpdateShoppingCartGoodsQtyRequestVo.class);
        BaseResponse shoppingCartGoodsResponseVo = shoppingCartNewService.updateGoodsQty(updateShoppingCartGoodsQtyRequestVo);
        log.debug("shoppingCartGoodsResponseVo:{}" , JSONObject.toJSONString(shoppingCartGoodsResponseVo));
    }

    @Test
    public void getGoodsList() {
        String requestJson = "{\n" +
                "    \"partnerId\": \"1864\",\n" +
                "    \"appId\": \"wxb78fb7c6218cb52c\",\n" +
                "    \"version\": \"1.5.2\",\n" +
                "    \"shopId\": \"999999998\",\n" +
                "    \"sessionId\": \"9f4da5564ee1b7d0c72a29ad854e58eb9be68c05\",\n" +
                "    \"orderType\": 1,\n" +
                "    \"flag\": 0\n" +
                "}";
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = JSONObject.parseObject(requestJson, ShoppingCartInfoRequestVo.class);
        BaseResponse shoppingCartGoodsResponseVo = shoppingCartNewService.getGoodsList(shoppingCartInfoRequestVo);
        log.debug("shoppingCartGoodsResponseVo==" + JSONObject.toJSONString(shoppingCartGoodsResponseVo));
    }

    @Test
    public void clearTest(){
        String version = SpringVersion.getVersion();
        String version1 = SpringBootVersion.getVersion();
        System.out.println(version);
        System.out.println(version1);
    }

}
