package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.ecology.ReportActivityBehaviorsRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 生态服务
 * @author: hujx
 * @date:  
 */
@FeignClient(name = "ecology-program-application", url = "${saas.ecology.program.application.feign.url:}")
public interface EcologyProgramApplicationClient {

    /**
     * 支付成功上报的低碳行为
     *
     * @return
     */
//    @LogIgnoreFeign(logMessage="sendLowCarbonAction")
    @PostMapping("/ecology/micro-program/low-carbon-action/activities/behaviors-report")
    BaseResponse reportActivityBehaviors(@RequestBody ReportActivityBehaviorsRequest request);
}
