package cn.freemud.entities.vo;

import lombok.Data;
import org.apache.commons.collections4.CollectionUtils;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CustomerInfoVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/5/25 15:35
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class CustomerInfoVo {
    private String openId;
    private String unionId;
    private String wxAppId;
    private String appSecret;
    private String sessionKey;
    private String nickName;
    private String photoUrl;
    private String mobile;
    private String memberId;
    private String partnerId;
    private Boolean newMember;
    private String sessionId;
    private String tableNumber;
    private String iappId;
    private String storeId;
    private String devBrand;
    private String devModel;
    private String channel;
    private String accessToken;
    private String alipayUserId;
    private String appId;
    private String thirdPartyPartnerID;
    private String thirdPartyMemberID;
    /** 付费会员卡列表 **/
    private List<MemberPaidDetailVo> memberPaids;
    /** 判断是否为付费会员 **/
    public boolean isMemberPaid(){
        if(CollectionUtils.isEmpty(memberPaids)){
            return false;
        }
        return memberPaids.stream().anyMatch(item -> item.getExpiryTime().getTime() > System.currentTimeMillis());
    }
}
