package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.NgsSellCouponCreateOrderVo;
import cn.freemud.entities.vo.SellCouponCreateOrderVo;
import cn.freemud.service.impl.SellCouponOrderServiceImpl;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: CreateOrderController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping1.wu
 * @date: 2020/5/21 17:16
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@RequestMapping("/order")
@RestController
@Validated
public class CreateOrderController {

    @Autowired
    private SellCouponOrderServiceImpl sellCouponOrderService;

    /**
     * 卖券订单创建
     */
    @ApiAnnotation(logMessage = "sellCouponOrderCreate")
    @PostMapping("/sellCouponOrder/create")
    public BaseResponse sellCouponOrderCreate(@Validated @LogParams @RequestBody SellCouponCreateOrderVo requestVo) {
        return sellCouponOrderService.createOrder(requestVo);
    }

    /**
     * 农工商卖券订单创建
     */
    @ApiAnnotation(logMessage = "sellCouponOrderCreate")
    @PostMapping("/ngs/sellCouponOrder/create")
    public BaseResponse ngsSellCouponOrderCreate(@Validated @LogParams @RequestBody NgsSellCouponCreateOrderVo requestVo) {
        return sellCouponOrderService.ngsCouponOrderCreate(requestVo);
    }


}
