package cn.freemud.demo.service;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.demo.entities.*;

public interface GetShoppingCartGoodsApportionService {

    /**
     *
     * 检验客制化的参数
     * @param baseRequestDTO
     * @return
     */
    default BaseResponse checkCustomParams(ShoppingCartGoodsApportionBO baseRequestDTO) {
        return ResponseBuilder.success();
    }


    /**
     * 获取购物车信息
     * @param baseRequestDTO
     * @return
     */
    default CheckBussinessRulesBO getShoppingCartInfo(ShoppingCartGoodsApportionBO baseRequestDTO) {
        return new CheckBussinessRulesBO();
    }

    /**
     * 进行客制化的业务校验
     * @param baseRequestDTO
     * @return
     */
    default AddGoodsToShoppingCartBO checkCustomBusinessRules(ShoppingCartGoodsApportionBO baseRequestDTO, CheckBussinessRulesBO checkBussinessRulesBO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO) {
        return addGoodsToShoppingCartBO;
    }



    /**
     * 购物车赋值
     * @param baseRequestDTO
     * @return
     */
    default DiscountResultBO customAddGoodsToShoppingCart(ShoppingCartGoodsApportionBO baseRequestDTO, AddGoodsToShoppingCartBO addGoodsToShoppingCartBO, DiscountResultBO customCalCostBO) {
        return customCalCostBO;
    }



    /**
     * 进行客制化的计算费用
     * @param baseRequestDTO
     * @return
     */
    default DistributeBO calCustomCost(ShoppingCartGoodsApportionBO baseRequestDTO, CalCostBO calCostBO, DistributeBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    default CalCostBO getDiscountResultBefore(ShoppingCartGoodsApportionBO baseRequestDTO, DiscountResultBO calCostBO) {
        return new CalCostBO();
    }

    /**
     * 客制化优惠计算
     * @param baseRequestDTO
     * @return
     */
    default CalCostBO getDiscountResultAfter(ShoppingCartGoodsApportionBO baseRequestDTO, DiscountResultBO calCostBO, CalCostBO commonSetMessageBO) {
        return commonSetMessageBO;
    }

    /**
     * 客制化优惠响应
     * @param baseRequestDTO
     * @return
     */
    default ShoppingCartApportionBO customDistribute(ShoppingCartGoodsApportionBO baseRequestDTO, DistributeBO calCostBO, ShoppingCartApportionBO commonSetMessageBO) {

        return commonSetMessageBO;
    }

    /**
     * 客制化信息提醒
     * @param baseRequestDTO
     * @return
     */
    default ShoppingCartApportionBO setCustomMessage(ShoppingCartGoodsApportionBO baseRequestDTO, ApportionSetMessageBO setMessageBO, ShoppingCartApportionBO shoppingCartGoodsBO) {
        return shoppingCartGoodsBO;
    }


}
