package cn.freemud.demo.manager.promotion;

import cn.freemud.demo.GetActivityBO;
import cn.freemud.demo.adapter.manager.PromotionBO2DTOAdapter;
import cn.freemud.demo.adapter.manager.PromotionDTO2BOAdapter;
import cn.freemud.demo.entities.ActivityBO;
import cn.freemud.demo.entities.CalculationDiscountBO;
import cn.freemud.demo.entities.GetCalculationDiscountBO;
import cn.freemud.demo.entities.QueryActivityByTypeDTO;
import cn.freemud.entities.dto.ActivityQueryRequestDto;
import cn.freemud.entities.dto.ActivityResponseDto;
import cn.freemud.entities.dto.activity.ActivityQueryDto;
import cn.freemud.entities.dto.activity.ActivityQueryResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountRequestDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.ActivityService;
import cn.freemud.service.thirdparty.CalculationClient;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.ErrorLog;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("KgdPromotionService")
@Slf4j
public class KgdPromotionServiceImpl implements PromotionService{

    @Autowired
    private CalculationClient calculationClient;

    @Autowired
    private ActivityService activityService;

    @Autowired
    private PromotionBO2DTOAdapter promotionBO2DTOAdapter;

    @Autowired
    private PromotionDTO2BOAdapter promotionDTO2BOAdapter;

    @Override
    public CalculationDiscountBO calculationDiscount(GetCalculationDiscountBO getCalculationDiscountBO) {

        CalculationSharingDiscountRequestDto shareDiscountRequestDto = promotionBO2DTOAdapter.convert2CalculationSharingDiscountRequestDto(getCalculationDiscountBO);
        CalculationSharingDiscountResponseDto calculationSharingDiscountResponseDto = null;
        try {
            log.info("start sharing discount dto={}", JSON.toJSONString(shareDiscountRequestDto));
            calculationSharingDiscountResponseDto = calculationClient.calculationSharingDiscount(shareDiscountRequestDto);
        }
        catch (Exception e) {
            ErrorLog.printErrorLog("calculation_discount_error", "/calculation/discount/sharing", calculationSharingDiscountResponseDto, e);
            throw new ServiceException(ResponseResult.OPERATE_TOO_OFTEN);
        }

        CalculationDiscountBO calculationDiscountBO = promotionDTO2BOAdapter.convert2CalculationDiscountBO(calculationSharingDiscountResponseDto);

        return calculationDiscountBO;
    }

    @Override
    public ActivityBO queryActivityByType(GetActivityBO getActivityBO) {

        QueryActivityByTypeDTO queryActivityByTypeDTO = promotionBO2DTOAdapter.convert2QueryActivityByTypeDTO(getActivityBO);

        ActivityQueryResponseDto activityQueryResponseDto = activityService.queryActivityByType(queryActivityByTypeDTO.getActivityQueryDto(),
                queryActivityByTypeDTO.getActivityTypeEnums(), queryActivityByTypeDTO.getGoodsBeanDtoList());
        if (activityQueryResponseDto != null && activityQueryResponseDto.getResult()!=null && activityQueryResponseDto.getResult().size()>0) {
            ActivityResponseDto activityResponseDto = activityQueryResponseDto.getResult().get(0);
            ActivityBO activityBO = promotionDTO2BOAdapter.convert2ActivityBO(activityResponseDto);
            return activityBO;
        }
        return null;
    }


}
