package cn.freemud.demo.adapter.manager;

import cn.freemud.demo.entities.CalculationDiscountBO;
import cn.freemud.demo.entities.DeliveryConfigBO;
import cn.freemud.demo.entities.StoreInfoBO;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.utils.BeanUtil;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerStoreDeliveryConfig;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import ma.glasnost.orika.MapperFacade;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class StoreDTO2BOAdapter {

    @Resource
    private MapperFacade mapperFacade;

    public StoreInfoBO convert2StoreInfoBO(StoreResponse.BizVO dto) {

        StoreInfoBO bo = BeanUtil.convertBean(dto, StoreInfoBO::new);

        return bo;
    }

    public DeliveryConfigBO convert2DeliveryConfigBO(AssortmentOpenPlatformPartnerStoreDeliveryConfig dto) {

        DeliveryConfigBO bo = BeanUtil.convertBean(dto, DeliveryConfigBO::new);

        return bo;
    }

}
