package cn.freemud.entities.db;

import javax.persistence.*;
import java.util.Date;

@Table(name = "open_store_iapp_wxapp_config")
public class OpenStoreIappWxappConfig {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 自定义小程序appid
     */
    private String appid;

    /**
     * 微信小程序appid
     */
    @Column(name = "wx_appid")
    private String wxAppid;

    /**
     * 是否允许填写备注文案，0=否，1=是
     */
    @Column(name = "take_inside")
    private Integer takeInside;

    /**
     * 到店订单默认文案
     */
    @Column(name = "inside_remark")
    private String insideRemark;

    /**
     * 外卖订单默认文案
     */
    @Column(name = "take_out_remark")
    private String takeOutRemark;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取自定义小程序appid
     *
     * @return appid - 自定义小程序appid
     */
    public String getAppid() {
        return appid;
    }

    /**
     * 设置自定义小程序appid
     *
     * @param appid 自定义小程序appid
     */
    public void setAppid(String appid) {
        this.appid = appid;
    }

    /**
     * 获取微信小程序appid
     *
     * @return wx_appid - 微信小程序appid
     */
    public String getWxAppid() {
        return wxAppid;
    }

    /**
     * 设置微信小程序appid
     *
     * @param wxAppid 微信小程序appid
     */
    public void setWxAppid(String wxAppid) {
        this.wxAppid = wxAppid;
    }

    /**
     * 获取是否允许填写备注文案，0=否，1=是
     *
     * @return take_inside - 是否允许填写备注文案，0=否，1=是
     */
    public Integer getTakeInside() {
        return takeInside;
    }

    /**
     * 设置是否允许填写备注文案，0=否，1=是
     *
     * @param takeInside 是否允许填写备注文案，0=否，1=是
     */
    public void setTakeInside(Integer takeInside) {
        this.takeInside = takeInside;
    }

    /**
     * 获取到店订单默认文案
     *
     * @return inside_remark - 到店订单默认文案
     */
    public String getInsideRemark() {
        return insideRemark;
    }

    /**
     * 设置到店订单默认文案
     *
     * @param insideRemark 到店订单默认文案
     */
    public void setInsideRemark(String insideRemark) {
        this.insideRemark = insideRemark;
    }

    /**
     * 获取外卖订单默认文案
     *
     * @return take_out_remark - 外卖订单默认文案
     */
    public String getTakeOutRemark() {
        return takeOutRemark;
    }

    /**
     * 设置外卖订单默认文案
     *
     * @param takeOutRemark 外卖订单默认文案
     */
    public void setTakeOutRemark(String takeOutRemark) {
        this.takeOutRemark = takeOutRemark;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_created - 创建时间
     */
    public Date getGmtCreated() {
        return gmtCreated;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreated 创建时间
     */
    public void setGmtCreated(Date gmtCreated) {
        this.gmtCreated = gmtCreated;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}