package cn.freemud.service.customer;

import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.member.GetMemberIdsReq;
import cn.freemud.entities.dto.member.GetMemberIdsResp;
import cn.freemud.service.thirdparty.CustomerClient;
import lombok.RequiredArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Clover.z
 * @Date 2021/11/2
 * @Desc 会员信息通用
 */
@Component
@RequiredArgsConstructor
public class MemberInfoManager {

    private final CustomerClient customerClient;

    /**
     * 查询会员名下的所有会员id（合并前的）
     * @param partnerId 商户号
     * @param memberId 会员编号
     * @return 所有的会员id集合
     */
    public List<String> getMemberAllIds(String partnerId, String memberId) {
        List<String> result = new ArrayList<>();
        GetMemberIdsReq query = new GetMemberIdsReq(partnerId, memberId);
        try {
            GetMemberIdsResp resp = customerClient.getMemberIds(query);
            if (null == resp || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(resp.getCode()) || CollectionUtils.isEmpty(resp.getData())) {
                result.add(memberId);
            } else {
                result = resp.getData();
            }
        } catch (Exception e) {
            // 该接口如果异常，不影响主链路流程
            result.add(memberId);
        }
        return result;
    }

}
