package cn.freemud.entities.vo.order;

import lombok.Data;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@Data
public class CreateOrderPremiumExchangeActivityVo {

    @NotNull(message = "activityCode 不能为空")
    private String activityCode;
    @NotNull(message = "activityName 不能为空")
    private String activityName;
    /**
     * 加价购sku商品信息
     */
    @Valid
    private List<Product> products;

    @Data
    public static class Product {
        /**
         * spuId 商品原始id
         */
        @NotNull(message = "spuId不能为空")
        private String spuId;

        /**
         * skuId 如果是多规格 skuId 不能为空
         */
        @NotNull(message = "skuId不能为空")
        private String skuId;
        /**
         * 商品名称
         */
        @NotNull(message = "商品名称不能为空")
        private String skuName;

        private String skuForeignName;

        @NotNull(message = "商品数量不能为空")
        private Integer qty;

        /**
         * 图片
         */
        private String picture;

        /**
         *  加价购 可能会涉及 虚拟商品  类型 = 9
         */
        private Integer productType;

        /**
         * 原价 入参不需要传，做对象组装使用
         */
        private Long originalPrice;
        /**
         * 现价 入参不需要传，做对象组装使用
         */
        private Long nowPrice;

        @Valid
        private List<Attribute> attributes;

        @Data
        public static class Attribute {
            /**
             * 属性ID
             */
            private String attributeId;

            /**
             * 属性名称
             */
            private String attributeValue;

            private String attributeForeignValue;

        }
    }

}
