/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderCallBackServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: ping.wu
 * @date: 2019/4/16 10:24
 * @version V1.0
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;

import cn.freemud.amp.service.OrderCallBackMQService;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.constant.ConfigConstants;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.service.OrderCallBackService;
import com.freemud.api.assortment.datamanager.util.RedisLock;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.ordercenter.entities.vo.OrderCallBackRequestVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.TimeUnit;


@Service
public class OrderCallBackServiceImpl implements OrderCallBackService{

    /**
     * cn.freemud.shared.order.enums.config.MsgOperateType.FORWARD(1, "订单正向操作"),
     */
    public static final int OPERATE_TYPE_1 = 1;
    /**
     * cn.freemud.shared.order.enums.MsgType.UPDATE_REMIND("1",  "订单信息变化通知通知")
     */
    public static final String MSG_TYPE_1 = "1";
    @Autowired
    private OrderCallBackMQService mqService;
    @Autowired
    private ConfigConstants configConstants;
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public BaseResponse orderCallBackHandle(OrderCallBackRequestVo requestVo) {
        //紧急方案打开 且是正向单时步入 锁控制代码
        if (configConstants.isUrgentCallbackOpen() && configConstants.getUrgentStatus().contains(requestVo.getOrderState()) && Objects.equals(OPERATE_TYPE_1, requestVo.getOperateType()) &&
                Objects.equals(MSG_TYPE_1, requestVo.getMsgType())) {
            this.urgentCallbackHandle(requestVo);
        } else {
            mqService.sendOrderMQ(requestVo);
        }
        return new BaseResponse("1", "100", "success");
    }

    private void urgentCallbackHandle(OrderCallBackRequestVo requestVo) {
        RedisLock redisLock = RedisLock.getInstance(redisTemplate);
        String lockKey = String.format(RedisKeyConstant.URGENT_CALLBACK_LOCK_KEY, requestVo.getOrderCode(),
                requestVo.getOrderState(), requestVo.getOperateType(), requestVo.getMsgType());
        boolean lockSucc =false;
        try {
            //简单控制，不考虑解他锁问题
            lockSucc = redisLock.lock(lockKey, Long.valueOf(TimeUnit.MINUTES.toSeconds(configConstants.getUrgentCallbackLockMinutes())).intValue());
            if (!lockSucc) {
                ApiLog.infoMessage("紧急方案 orderCode:{} 获取锁失败,lockKey:{}", requestVo.getOrderCode(), lockKey);
                return;
            }
            mqService.sendOrderMQ(requestVo);
        } finally {
            if (lockSucc){
                ApiLog.infoMessage("紧急方案 orderCode:{} 理论成功lockKey:{}", requestVo.getOrderCode(),lockKey);
                redisLock.unlock(lockKey);
            }
        }
    }

}
