package cn.freemud.entities.dto.calculate;

import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.shoppingCart.SendPoint;
import cn.freemud.entities.vo.SubtractStockVO;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class CalculationSharingDiscountResponseDto {

    private Integer ver;
    /**
     * 状态码
     */
    private String statusCode;

    /**
     * 状态码描述
     */
    private String msg;

    /**
     * 优惠后运费
     */
    private Long distributionFee;

    /**
     * 集合外的为系统按照优先级计算出来的优惠信息
     * ，calculationResults集合中的为多种优惠方案
     * 计算出来的优惠信息列表，并按优惠力度倒序排列
     */
    private CalculationDiscountResult result;

    @Data
    public static class CalculationDiscountResult {
        /**
         * 原总价（分）
         */
        private Long originalTotalAmount;
        /**
         * 需支付金额（分）
         */
        private Long totalAmount;
        /**
         * 总优惠金额（分）
         */
        private Long totalDiscountAmount;
        /**
         * 总的优惠信息集合
         */
        private List<Discount> discounts;
        /**
         * 商品优惠信息
         */
        private List<Goods> goods;
        /**
         * 赠送、换购商品信息集合
         */
        private List<SendActivity> sendGoods;
        /**
         * 满额赠券活动号列表
         */
        private List<String> sendCoupons;
        /**
         * 使用到的优惠券及优惠金额
         */
        private List<CouponResults> couponDiscounts;


        /**
         * 多种优惠方案计算出的优惠集合，并按优惠力度倒序排列
         */
//        private List<CalculationResult> calculationResults;

        List<ApportionGoods> apportionGoods;
        /**
         * 促销活动
         */
        List<ActivityPrompt> activityPrompts;

        /**
         * 校验后有效的商品券map
         */
        private Map<String, CheckSpqInfoResponseDto> validCouponMap;
        /**
         * 校验后有效的spqid对应的uuid
         */
        private Map<String, List<String>> spqIdToCartUuid;

        /**
         * 扣减库存
         */
        private List<SubtractStockVO> stocks;

        /**
         * 配送费
         */
        private Long deliveryAmount;

        /**
         * 优惠后 配送费
         */
        private Long distributionFee;

        private SendPoint sendPointVo;

        @Data
        public static class ActivityPrompt {

            private String acitivityName;
            private String activityCode;
            private Integer activityType;
            private Long discountAmout;
            private Long thresholdAmount;
            private Long totalAmount;
            private Long alreadyDiscountAmount;
            private Integer activitySubType;
            private List<SendGoods> sendGoods;
        }
        @Data
        public static class SendGoods {
            private String  goodsId;
            private String  goodsName;
            private Integer  sendNumber;
        }
        @Data
        public static class Discount {
            /**
             * 活动号
             */
            private String activityCode;
            /**
             * 活动名称
             */
            private String activityName;
            /**
             * 活动描述
             */
            private String activityDesc;
            /**
             * 每个活动优惠总金额（单位分）
             */
            private Integer discount;
            /**
             * 优惠类型：
             * 1-整单满减
             * 11-每满减
             * 12-阶梯满减
             * 2-单品特价
             * 14-满额减配送费
             * 21-单品折扣
             * 3-优惠券
             * 5-整单满金额折
             * 51-每满金额折
             * 52-阶梯满金额折
             * 53-第M件/杯N折
             * 6-买M赠N
             * 7-满额赠券
             * 8-满N件换购
             * 81-满额换购
             * 82-阶梯满数量打折
             * 83-整单满数量打折
             */
            private Integer type;

            private Long thresholdAmount;
            private SendPointDto sendPointVo;
            private Date endTime;
            private Boolean zeroDiscount;

            private Integer integral;
        }

        @Data
        public static class SendPointDto {
            private String activityCode;
            private Integer sendPoint;
            private Integer maxNum;
            private Integer exchangeNum;
            private Integer validityDateDays;
            private Date endTime;
            private Boolean storeLevel;
            private Integer isContinueExchange;
        }

        @Data
        public static class Goods {

            /**
             * 买一赠一时，存赠送主商品的cartGoodsUid 用于标记是那个商品送的
             */
            private String originalGoodsUid;

            /**
             * 购物车行记录
             */
            private String cartGoodsUid;
            /**
             * 0 原购物车商品 1 赠送商品  2 换购商品
             */
            private Integer cartGoodType;
            /**
             * 商品id
             */
            private String goodsId;
            /**
             * 商品数量
             */
            private Integer goodsQuantity;
            /**
             * 商品原价（分）
             */
            private Long originalPrice;
            /**
             * 商品现价（分）
             */
            private Long nowPrice;
            /**
             * 分摊到商品上的优惠总金额
             */
            private Long discountAmount;
            /**
             * 商品实付金额
             */
            private Long realAmount;
            /**
             * 实际优惠的商品数量
             */
            private Integer actualGoodsNumber;
            /**
             * 单品享受的活动
             */
            private List<GoodsDiscount> discounts;

            /**
             * 套餐固定商品组
             */
            private List<GroupCombox> groupCombox;
            /**
             * 商品的小料集合
             */
            private List<SmallMaterial> smallMaterial;
            private Boolean gift = false;
            private Boolean meal = false;

            /**
             * 当前商品享受的活动
             */
            @Data
            public static class GoodsDiscount {
                /**
                 * 活动号
                 */
                private String activityCode;
                /**
                 * 活动名称
                 */
                private String activityName;
                /**
                 * 活动描述
                 */
                private String activityDesc;

                /**
                 * 商品ID
                 */
                private String goodsId;
                /**
                 * 折扣金额
                 */
                private Long discount;

                /**
                 * 活动类型
                 */
                private Integer type;
                /**
                 * 当前活动实际优惠的商品数量
                 */
                private Integer actualGoodsNumber;

                /**
                 * 优惠现单价
                 */
                private Long signleDiscount;
            }

            /**
             * 当前套餐数据
             */
            @Data
            @NoArgsConstructor
            public static class GroupCombox {
                /**
                 * 商品id
                 */
                private String goodsId;
                /**
                 * 商品数量
                 */
                private Integer goodsQuantity;
                /**
                 * 商品原价
                 */
                private Integer originalPrice;
                /**
                 * 商品现价
                 */
                private Integer nowPrice;
                /**
                 * 商品现价
                 */
                private Integer realAmount;
                /**
                 * 总优惠
                 */
                private Integer discountAmount;
                /**
                 * 优惠信息
                 */
                List<GoodsDiscount> discounts;
            }

            /**
             * 小料集合
             */
            @Data
            @NoArgsConstructor
            public static class SmallMaterial {
                /**
                 * 商品ID
                 */
                private String goodsId;
                /**
                 * 商品数量
                 */
                private Integer goodsQuantity;
                /**
                 * 商品原价
                 */
                private Integer originalPrice;

                /**
                 * 购物车商品行id  购物车用于区分两个一样的goodsId   计算后原样返回给购物车
                 */
                private String cartGoodsUid;

                //1，小料；2，可选搭配
                private Integer type;
                /**
                 * 总优惠金额
                 */
                private Integer discountAmount;

                /**
                 * 实付金额
                 */
                private Integer realAmount;
                private List<GoodsDiscount> discounts;
            }
        }

        @Data
        public static class SendActivity {
            /**
             * 活动号
             */
            private String activityCode;
            /**
             * 活动名称
             */
            private String activityName;
            /**
             * 活动类型
             */
            private Integer activityType;
            /**
             * 可选赠送商品最大数量
             */
            private Integer maxNum;
            /**
             * 可选赠送商品最小数量
             */
            private Integer minNum;
            /**
             * 买M送N时，送ABC中选其中几个
             */
            private Integer sendKinds;
            private List<SendGoods> sendGoods;

            @Data
            public static class SendGoods {

                /**
                 * 买一赠一时，存赠送主商品的cartGoodsUid 用于标记是那个商品送的
                 */
                private String originalGoodsUid;

                /**
                 * 赠送商品ID
                 */
                private String goodsId;
                /**
                 * 品类
                 */
                private String category;
                /**
                 * 赠送商品名称
                 */
                private String goodsName;
                /**
                 * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
                 */
                private Long nowPrice;
                /**
                 * 赠送商品原价
                 */
                private Long originalPrice;
                /**
                 * 赠送商品数量
                 */
                private Integer sendNumber;

                /**
                 *  可兑换商品券编号
                 */
                private String sendCouponCode;

                /**
                 *  可兑换商品券名称
                 */
                private String sendCouponName;

                /**
                 *  是否已选择寄杯
                 */
                private Boolean sendCoupon ;
            }
        }

        @Data
        public static class CouponResults {
            /**
             * 优惠券号
             */
            private String couponCode;
            /**
             * 优惠金额（单位分）
             */
            private Integer discountAmount;
        }

        @Data
        public static class CalculationResult {
            /**
             * 原总价（分）
             */
            private Integer originalTotalAmount;
            /**
             * 需支付金额（分）
             */
            private Integer totalAmount;
            /**
             * 总优惠金额（分）
             */
            private Integer totalDiscountAmount;
            /**
             * 总的优惠信息集合
             */
            private List<Discount> discounts;

            /**
             * 商品优惠信息
             */
            private List<Goods> goods;

            /**
             * 赠送、换购商品信息集合
             */
            private List<SendActivity> sendGoods;
        }

        @Data
        public static class ApportionGoods {

            /**
             * 商品id
             */
            private String goodsId;
            /**
             * 商品数量
             */
            private Integer goodsQuantity;
            /**
             * 商品原价（分）
             */
            private Long originalPrice;
            /**
             * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
             */
            private Long nowPrice;
            /**
             * 均摊金额
             */
            private Integer apportionAmount;

            private List<ApportionDetails> apportionDetails;
            private List<Material> smallMaterial;
            /**
             * 购物车行记录
             */
            private String cartGoodsUid;

            @Data
            public static class ApportionDetails {
                /**
                 * 活动code,如果是商品券，优惠券，放券code
                 */
                private String activityCode;
                /**
                 * 活动类型  ActivityTypeEnum 枚举，不能为空
                 */
                private Integer activityType;
                /**
                 * 活动名称，如果是商品券，优惠券，放券名称
                 */
                private String activityName;
                /**
                 * 特价价格 比如限时特价价格
                 */
                private Long goodsNowPrice;
                /**
                 * 折扣比率 百分比，非必传  有折扣活动
                 */
                private Long activityRebate;
                /**
                 * 促销类型  交易类促销  商品类促销  ApportionType
                 */
                private Integer apportionType;
                /**
                 * 活动均摊金额
                 */
                private Long activityApportionAmount;
            }

            @Data
            @NoArgsConstructor
            public static class Material {
                /**
                 * 均摊金额
                 */
                private Integer apportionAmount;
                /**
                 * 购物车行记录
                 */
                private String cartGoodsUid;

                /**
                 * 商品id
                 */
                private String goodsId;

                /**
                 * 商品数量
                 */
                private Integer goodsQuantity;

                /**
                 * 赠送商品现价（单位：分）（加价换购时表示需要加的价格）
                 */
                private Long nowPrice;

                /**
                 * 商品原价（分）
                 */
                private Long originalPrice;
                private List<ApportionDetails> apportionDetails;

            }
        }
    }
}
