package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.management.adapter.WaimaiSdkAdapter;
import cn.freemud.management.entities.dto.request.order.McCafeOrderManagerRequest;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderManagerResponse;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.intercept.OrderServiceException;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.takeaway.request.order.AgreeOrderRequest;
import com.freemud.application.sdk.api.takeaway.request.order.OrderSendOutRequest;
import com.freemud.application.sdk.api.takeaway.request.order.PartnerCancelRequest;
import com.freemud.application.sdk.api.takeaway.request.order.PlatformOrderRequest;
import com.freemud.application.sdk.api.takeaway.service.WaimaiOrderService;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: 外卖订单履单操作
 * @author: shuhu.hou
 * @date: 2020/3/26 16:01
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class WaimaiOrderMangerServiceImpl implements OrderManagerService {

    @Autowired
    private WaimaiOrderService waimaiOrderService;
    @Autowired
    private WaimaiSdkAdapter waimaiSdkAdapter;

    /**
     * 接单
     * @param request 请求参数
     * @param orderBean 订单实体
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderConfirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        PlatformOrderRequest platformOrderRequest = waimaiSdkAdapter.getPlatformOrderRequest(request, orderBean);
        com.freemud.application.sdk.api.base.BaseResponse waimaiBaseResponse = waimaiOrderService.confirm(platformOrderRequest, LogTreadLocal.getTrackingNo());
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), waimaiBaseResponse.getCode())) {
            throw new OrderServiceException(ResponseResult.ORDER_ACCEPT_FAILED);
        }
        return ResponseUtil.success();
    }

    @Override
    public BaseResponse mcCafeOrderConfirm(McCafeOrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return null;
    }

    /**
     * 制作完成
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderDone(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return  ResponseUtil.success();
    }

    /**
     * 订单配送
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderDelivery(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderSendOutRequest orderSendOutRequest = waimaiSdkAdapter.getOrderSendOutRequest(request, orderBean);
        com.freemud.application.sdk.api.base.BaseResponse sendoutResponse = waimaiOrderService.sendout(orderSendOutRequest, LogTreadLocal.getTrackingNo());
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), sendoutResponse.getCode())) {
            return ResponseUtil.error(ResponseResult.DELIVERY_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 订单完成
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAffirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderSendOutRequest orderArriveRequest = waimaiSdkAdapter.getOrderArriveRequest(request, orderBean);
        com.freemud.application.sdk.api.base.BaseResponse arriveResponse = waimaiOrderService.arrive(orderArriveRequest, LogTreadLocal.getTrackingNo());
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), arriveResponse.getCode())) {
            return ResponseUtil.error(ResponseResult.AFFIRM_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒单
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderReject(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        PartnerCancelRequest partnerCancelRequest = waimaiSdkAdapter.getPartnerCancelRequest(request, orderBean);
        com.freemud.application.sdk.api.base.BaseResponse rejectResponse = waimaiOrderService.reject(partnerCancelRequest, "");
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), rejectResponse.getCode())) {
            return ResponseUtil.error(ResponseResult.REJECT_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    @Override
    public BaseResponse mcCafeOrderReject(McCafeOrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        return null;
    }

    /**
     * 同意退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderAgreeRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        AgreeOrderRequest agreeOrderRequest = waimaiSdkAdapter.getAgreeOrderRequest(request, orderBean,true);
        com.freemud.application.sdk.api.base.BaseResponse agreeRefundResponse = waimaiOrderService.isAgreeRefund(agreeOrderRequest, "");
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), agreeRefundResponse.getCode())) {
            return ResponseUtil.error(ResponseResult.AGREE_REFUND_ORDER_FAIL);
        }
        return ResponseUtil.success();
    }

    /**
     * 拒绝退款
     *
     * @param request
     * @param orderBean
     * @return
     */
    @Override
    public BaseResponse<OrderManagerResponse> orderRejectRefund(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        AgreeOrderRequest agreeOrderRequest = waimaiSdkAdapter.getAgreeOrderRequest(request, orderBean,false);
        com.freemud.application.sdk.api.base.BaseResponse agreeRefundResponse = waimaiOrderService.isAgreeRefund(agreeOrderRequest, "");
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(), agreeRefundResponse.getCode())) {
            return ResponseUtil.error(ResponseResult.REJECT_REFUND_ORDER_FAIL);
        }
        return ResponseUtil.success();

    }
}
