package cn.freemud.demo.entities.bo.promotion;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class CouponDetailBO {

    /**
     *表示接口处理是否成功，1表示成功，0表示失败
     */
    private Integer result;
    private Integer statusCode;
    private Integer ver;
    private List<CouponDetailBO.Errors> errors;
    private List<CouponDetailBO.Details> details;
    @Data
    public static class Details{
        private String code;
        private String activeCode;
        private String title;
        private Integer type;
        private Integer status;
        private String create_time;
        private String redeem_time;
        private String valid_start;
        private String valid_ends;
        private String minAmount;
        private CouponDetailBO.Active active;
        private List<CouponDetailBO.ActiveProduct> activeProduct;
        private List<CouponDetailBO.ActiveRestrictionVOS> activeRestrictionVOS;
    }
    @Data
    public static class Active{
        @JsonProperty("ActiveCode")
        private String activeCode;
        @JsonProperty("ActiveDesc")
        private String activeDesc;
        @JsonProperty("ActiveName")
        private String activeName;
        @JsonProperty("BusinessID")
        private Integer businessId;
        @JsonProperty("CreateDate")
        private String createDate;
        @JsonProperty("CreateUser")
        private String createUser;
        @JsonProperty("EBCode")
        private String ebCode;
        @JsonProperty("EndDate")
        private String endDate;
        @JsonProperty("EndString")
        private String endString;
        @JsonProperty("Inventory")
        private Integer inventory;
        @JsonProperty("LastEditDate")
        private String lastEditDate;
        @JsonProperty("LastEditUser")
        private String lastEditUser;
        @JsonProperty("MaxDiscount")
        private Integer maxDiscount;
        @JsonProperty("MaxRedeemTimes")
        private Integer maxRedeemTimes;
        @JsonProperty("MinAmount")
        private Integer minAmount;
        @JsonProperty("PartnerID")
        private String partnerId;
        @JsonProperty("PercentDiscount")
        private Integer percentDiscount;
        @JsonProperty("Percentage")
        private Integer percentage;
        @JsonProperty("PromotionType")
        private String promotionType;
        @JsonProperty("ShouldRedeemAll")
        private Boolean shouldRedeemAll;
        @JsonProperty("StartDate")
        private String startDate;
        @JsonProperty("StartString")
        private String startString;
        @JsonProperty("State")
        private Integer state;
        @JsonProperty("Type")
        private Integer type;
    }
    @Data
    public static class ActiveProduct{
        @JsonProperty("ActiveID")
        private Integer activeId;
        @JsonProperty("Amount")
        private Integer amount;
        @JsonProperty("Paid")
        private Integer paid;
        @JsonProperty("Price_Discount")
        private BigDecimal priceDiscount;
        @JsonProperty("Price_Original")
        private BigDecimal priceOriginal;
        @JsonProperty("Product")
        private String product;
        @JsonProperty("ProductID")
        private Integer productId;
        @JsonProperty("ProductID_Partner")
        private String productIdPartner;
        @JsonProperty("Remain")
        private Integer remain;
    }
    @Data
    public static class ActiveProductSetting{
    }
    @Data
    public static class ActiveRestrictionVOS{
        @JsonProperty("ActiveID")
        private String activeId;
        @JsonProperty("City")
        private String city;
        @JsonProperty("StoreIDPartner")
        private String storeIdPartner;
    }
    @Data
    public static class Errors{
        @JsonProperty("error_code")
        private String errorCode;
        private String parameter;
    }

}
