/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: StoreController
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/11 19:14
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.thirdparty;

import cn.freemud.entities.dto.*;
import com.freemud.application.sdk.api.storecenter.request.ChangeTableOrderStateRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreBaseResponse;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@FeignClient(name = "CONSOLE-API",url = "http://172.81.204.212:8715")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface StoreClient {

    /**
     * 查询附近门店
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/api/v2/organization/nearStoreList", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreListResponseDto> findNearStores(@RequestBody NearStoreRequestDto request);

    /**
     * 查询单个门店信息
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/api/v2/organization/get", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreResponseDto> getStoreInfo(@RequestBody StoreInfoRequestDto request);

    /**
     * 查询门店轮播图
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/api/v2/storeImage/list", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreImageListResponseDto> findStoreImages(@RequestBody StoreImagesRequestDto request);

    @PostMapping(value = "/storecenter/storetable/v2/tableActiveFlagChange", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    StoreBaseResponseDto<StoreBaseResponse> changeTableNumberStatus(@RequestBody ChangeTableOrderStateRequest changeTableOrderStateRequest);
}
