package cn.freemud.service;

import cn.freemud.ShoppingCartApplication;
import cn.freemud.entities.dto.CheckSpqInfoRequestDto;
import cn.freemud.entities.dto.CheckSpqInfoResponseDto;
import cn.freemud.entities.dto.GetCouponDetailResponseDto;
import cn.freemud.entities.dto.calculate.CalculationSharingDiscountResponseDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.StoreItemStatus;
import cn.freemud.service.impl.calculate.CalculationCommonService;
import cn.freemud.service.impl.calculate.promotion.AdditionSharingService;
import cn.freemud.service.impl.calculate.promotion.FullSharingService;
import cn.freemud.service.impl.calculate.promotion.GiftSharingService;
import cn.freemud.utils.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.freemud.card.sdk.comm.Finals;
import com.freemud.card.sdk.comm.SignUtil;
import com.freemud.card.sdk.service.*;
import com.freemud.card.sdk.util.DateUtil;
import com.freemud.card.sdk.vo.comm.GetCodeRespVo;
import com.freemud.card.sdk.vo.comm.GetCouponVo;
import com.freemud.card.sdk.vo.coupon.CouponVo;
import com.freemud.card.sdk.vo.coupon.MemberCouponVo;
import com.freemud.card.sdk.vo.coupon.request.ActiveInsertRequest;
import com.freemud.card.sdk.vo.coupon.request.MemberCardVo;
import com.freemud.card.sdk.vo.coupon.request.PromotionUserCouponReqVo;
import com.freemud.card.sdk.vo.coupon.response.ActiveInsertRespVo;
import com.freemud.card.sdk.vo.coupon.response.MemberCouponRespVo;
import com.freemud.card.sdk.vo.coupon.response.PromotionBaseRespVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title:
 * @Package: com.freemud.card.sdk
 * @Description:
 * @author: genyou.cui
 * @date: 2018/12/17 16:34
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = ShoppingCartApplication.class)
public class CartTest {

    private static final Logger logger = LoggerFactory.getLogger(CartTest.class);
    @Autowired
    private GiftSharingService giftSharingService;
    @Autowired
    private CalculationCommonService calculationCommonService;
    @Autowired
    private FullSharingService fullSharingService;
    @Autowired
    private AdditionSharingService additionSharingService;


    @Test
    public void cartTest() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"套餐lulu34\",\"originalPrice\":3830,\"goodsId\":\"177302125478533179\",\"productMaterialList\":[],\"customerCode\":\"55555552345789876543212345678909876543234567890987\",\"finalPrice\":500,\"createTimeMili\":1602306494889,\"pic\":\"https://picture.sandload.cn/1594880528035.jpg\",\"productComboList\":[{\"spuName\":\"单品lulu4\",\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"customerCode\":\"8765\",\"finalPrice\":500,\"pic\":\"https://picture.sandload.cn/1598261441993.jpg\",\"extra\":[{\"attributeId\":\"154178730067056650\",\"attributeName\":\"加水\"}],\"specProductId\":\"154178730067056650\",\"skuId\":\"170060233309334535\",\"amount\":500,\"weight\":5.18,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":500,\"subName\":\"加水\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu4\"},{\"spuName\":\"单品lulu3\",\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"customerCode\":\"852852\",\"finalPrice\":350,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"163358286692775186\",\"attributeName\":\"重麻\"},{\"attributeId\":\"163358360337413399\",\"attributeName\":\"重辣\"}],\"specProductId\":\"163358286692775186/163358360337413399\",\"skuId\":\"170060198366587966\",\"amount\":350,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":350,\"subName\":\"重麻/重辣\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu3\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"套餐lulu34\",\"riseSell\":1,\"classificationName\":\"\",\"productGroupList\":[{\"spuName\":\"柚子的单品多属性\",\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"productGroupId\":161989603366078508,\"customerCode\":\"4543543543\",\"finalPrice\":2980,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"152211084882987801\",\"attributeName\":\"不加糖\"},{\"attributeId\":\"185339298173928979\",\"attributeName\":\"中快\"}],\"specProductId\":\"152211084882987801/185339298173928979\",\"skuId\":\"161827301887133737\",\"amount\":2980,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":2980,\"subName\":\"不加糖/中快\",\"taxId\":\"\",\"qty\":1,\"name\":\"柚子的单品多属性\"}],\"memberDiscount\":100,\"skuId\":\"177302125478533179\",\"amount\":3830,\"cartGoodsUid\":\"e74a2fad-49c6-4f73-bd2f-adbdd905277c\",\"stockLimit\":false,\"weight\":0.01,\"tax\":0.01,\"classificationId\":\"\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":3830,\"subName\":\"\",\"taxId\":\"\",\"qty\":1,\"name\":\"套餐lulu34\",\"materialAmount\":0,\"spuId\":\"177302125478533179\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":3830,\"totalDiscountAmount\":1150,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":2294,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"161827301887133737\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":686,\"type\":12,\"activityDesc\":\"description\"}],\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"discountAmount\":686,\"goodsQuantity\":1,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060233309334535\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":206,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"170060233309334535\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":67,\"type\":12}],\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"discountAmount\":273,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060198366587966\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":143,\"type\":310,\"activityDesc\":\"套餐活动优惠\"},{\"goodsId\":\"170060198366587966\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":46,\"type\":12}],\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"discountAmount\":189,\"goodsQuantity\":1}],\"cartGoodsUid\":\"e74a2fad-49c6-4f73-bd2f-adbdd905277c\",\"originalPrice\":850,\"goodsId\":\"177302125478533179\",\"actualGoodsNumber\":1,\"discountAmount\":464,\"meal\":true,\"realAmount\":386,\"nowPrice\":500,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"177302125478533179\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":1,\"discount\":114,\"type\":12},{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"177302125478533179\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"sendGoods\":[{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"activityType\":81,\"maxNum\":3,\"sendGoods\":[{\"nowPrice\":100,\"originalPrice\":1300,\"goodsId\":\"186550397673068596\",\"sendNumber\":1,\"category\":\"186550397673068596\",\"goodsName\":\"桔子单品12\"},{\"nowPrice\":100,\"originalPrice\":1200,\"goodsId\":\"186550397637417010\",\"sendNumber\":1,\"category\":\"186550397637417010\",\"goodsName\":\"桔子单品11\"},{\"nowPrice\":100,\"originalPrice\":1100,\"goodsId\":\"186550397599668272\",\"sendNumber\":1,\"category\":\"186550397599668272\",\"goodsName\":\"桔子单品10\"}],\"minNum\":0}],\"stocks\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"activityStock\":1,\"activityType\":12,\"goodsStock\":[]},{\"activityCode\":\"MEHG2020092914160146595\",\"activityType\":81,\"goodsStock\":[{\"goodsId\":\"186550397673068596\",\"stock\":1},{\"goodsId\":\"186550397637417010\",\"stock\":1},{\"goodsId\":\"186550397599668272\",\"stock\":1}]}],\"totalAmount\":2680,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"thresholdAmount\":1000,\"activityName\":\"丹妮满减\",\"discount\":800,\"type\":12,\"activityDesc\":\"description\"},{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"discount\":0,\"type\":81,\"activityDesc\":\"\"},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        //fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
    }


    @Test
    public void cartTest2() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"套餐lulu34\",\"originalPrice\":3830,\"goodsId\":\"177302125478533179\",\"productMaterialList\":[],\"customerCode\":\"55555552345789876543212345678909876543234567890987\",\"finalPrice\":500,\"createTimeMili\":1602307490826,\"pic\":\"https://picture.sandload.cn/1594880528035.jpg\",\"productComboList\":[{\"spuName\":\"单品lulu4\",\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"customerCode\":\"8765\",\"finalPrice\":500,\"pic\":\"https://picture.sandload.cn/1598261441993.jpg\",\"extra\":[{\"attributeId\":\"154178730067056650\",\"attributeName\":\"加水\"}],\"specProductId\":\"154178730067056650\",\"skuId\":\"170060233309334535\",\"amount\":500,\"weight\":5.18,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":500,\"subName\":\"加水\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu4\"},{\"spuName\":\"单品lulu3\",\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"customerCode\":\"852852\",\"finalPrice\":350,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"163358286692775186\",\"attributeName\":\"重麻\"},{\"attributeId\":\"163358360337413399\",\"attributeName\":\"重辣\"}],\"specProductId\":\"163358286692775186/163358360337413399\",\"skuId\":\"170060198366587966\",\"amount\":350,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":350,\"subName\":\"重麻/重辣\",\"taxId\":\"\",\"qty\":1,\"name\":\"单品lulu3\"}],\"categoryName\":\"套餐\",\"originalMaterialAmount\":0,\"packPrice\":0,\"skuName\":\"套餐lulu34\",\"riseSell\":1,\"classificationName\":\"\",\"productGroupList\":[{\"spuName\":\"柚子的单品多属性\",\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"productGroupId\":161989603366078508,\"customerCode\":\"4543543543\",\"finalPrice\":2980,\"pic\":\"https://img10.sandload.cn/zfx01.jpg?timestamp=1593832540030\",\"extra\":[{\"attributeId\":\"152211084882987801\",\"attributeName\":\"不加糖\"},{\"attributeId\":\"185339298173928979\",\"attributeName\":\"中快\"}],\"specProductId\":\"152211084882987801/185339298173928979\",\"skuId\":\"161827301887133737\",\"amount\":2980,\"weight\":0.0,\"tax\":0.01,\"weightType\":false,\"unit\":\"g\",\"originalAmount\":2980,\"subName\":\"不加糖/中快\",\"taxId\":\"\",\"qty\":1,\"name\":\"柚子的单品多属性\"}],\"memberDiscount\":100,\"skuId\":\"177302125478533179\",\"amount\":3830,\"cartGoodsUid\":\"e3838500-7049-44f6-af86-e2bbb7d33776\",\"stockLimit\":false,\"weight\":0.01,\"tax\":0.01,\"classificationId\":\"\",\"goodsType\":3,\"weightType\":false,\"unit\":\"\",\"originalAmount\":3830,\"subName\":\"\",\"taxId\":\"\",\"qty\":1,\"name\":\"套餐lulu34\",\"materialAmount\":0,\"spuId\":\"177302125478533179\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":3830,\"totalDiscountAmount\":350,\"deliveryAmount\":1,\"distributionFee\":1,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":2980,\"discounts\":[],\"originalPrice\":2980,\"goodsId\":\"161827301887133737\",\"discountAmount\":0,\"goodsQuantity\":1,\"type\":2}],\"groupCombox\":[{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060233309334535\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":206,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"originalPrice\":500,\"goodsId\":\"170060233309334535\",\"discountAmount\":206,\"goodsQuantity\":1},{\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"170060198366587966\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":143,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"originalPrice\":350,\"goodsId\":\"170060198366587966\",\"discountAmount\":143,\"goodsQuantity\":1}],\"cartGoodsUid\":\"e3838500-7049-44f6-af86-e2bbb7d33776\",\"originalPrice\":850,\"goodsId\":\"177302125478533179\",\"discountAmount\":350,\"meal\":true,\"realAmount\":500,\"nowPrice\":500,\"discounts\":[{\"activityCode\":\"TCYH0000000001\",\"goodsId\":\"177302125478533179\",\"activityName\":\"套餐活动优惠\",\"actualGoodsNumber\":0,\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"sendGoods\":[{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"activityType\":81,\"maxNum\":3,\"sendGoods\":[{\"nowPrice\":100,\"originalPrice\":1300,\"goodsId\":\"186550397673068596\",\"sendNumber\":1,\"category\":\"186550397673068596\",\"goodsName\":\"桔子单品12\"},{\"nowPrice\":100,\"originalPrice\":1200,\"goodsId\":\"186550397637417010\",\"sendNumber\":1,\"category\":\"186550397637417010\",\"goodsName\":\"桔子单品11\"},{\"nowPrice\":100,\"originalPrice\":1100,\"goodsId\":\"186550397599668272\",\"sendNumber\":1,\"category\":\"186550397599668272\",\"goodsName\":\"桔子单品10\"}],\"minNum\":0}],\"stocks\":[{\"activityCode\":\"MEHG2020092914160146595\",\"activityType\":81,\"goodsStock\":[{\"goodsId\":\"186550397673068596\",\"stock\":1},{\"goodsId\":\"186550397637417010\",\"stock\":1},{\"goodsId\":\"186550397599668272\",\"stock\":1}]}],\"totalAmount\":3480,\"discounts\":[{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"discount\":0,\"type\":81,\"activityDesc\":\"\"},{\"activityCode\":\"TCYH0000000001\",\"activityName\":\"套餐活动优惠\",\"discount\":350,\"type\":310,\"activityDesc\":\"套餐活动优惠\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 满减处理
         */
        //fullSharingService.fullResponse(discountResult, cartGoodsList, shoppingCartGoodsResponseVo, null);
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        //ShoppingCartInfoRequestVo
        String shoppingCartInfoRequestVoStr = "{\"premiumExchangeActivity\":{\"activityCode\":\"MEHG2020092914160146595\",\"activityName\":\"丹妮加价购活动\",\"products\":[{\"attributes\":[],\"originalPrice\":1300,\"qty\":1,\"skuId\":\"186550397673068596\",\"skuName\":\"桔子单品12\",\"spuId\":\"186550397673068596\"}]},\"shoppingCartInfoRequestVo\":{\"flag\":0,\"menuType\":\"saas\",\"orderType\":1,\"partnerId\":\"2399\",\"reachStoreType\":4,\"receiveId\":\"3584084950985469155\",\"sessionId\":\"146e3ced5884092de0ba3d0369cf7dc338b515c8\",\"shopId\":\"716001\",\"useCustomerScore\":2,\"version\":\"2.0.1\"}}";
        GetShoppingCartGoodsApportionRequestVo getShoppingCartGoodsApportionRequestVo = JSONObject.parseObject(shoppingCartInfoRequestVoStr, new TypeReference<GetShoppingCartGoodsApportionRequestVo>() {
        });
        /**
         * 加价购商品
         */
        additionSharingService.equally(getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo(), null, discountResult, getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity());
    }

    @Test
    public void gift() {
        ShoppingCartGoodsResponseVo shoppingCartGoodsResponseVo = new ShoppingCartGoodsResponseVo();
        /**
         * json string
         */
        String cartGoodsListStr = "[{\"spuName\":\"桔子21\",\"originalPrice\":1000,\"goodsId\":\"187356238100648503\",\"productMaterialList\":[{\"amount\":100,\"spuName\":\"加肉\",\"originalAmount\":100,\"originalPrice\":100,\"finalPrice\":100,\"spuId\":\"182747638728442153\"}],\"customerCode\":\"187356238100648503\",\"finalPrice\":1000,\"createTimeMili\":1602408131581,\"pic\":\"https://picture.sandload.cn/1601460901562.png\",\"productComboList\":[],\"originalMaterialAmount\":100,\"packPrice\":0,\"skuName\":\"桔子21/大杯\",\"riseSell\":1,\"classificationName\":\"\",\"extra\":[],\"productGroupList\":[],\"memberDiscount\":5,\"skuId\":\"187356238100648503\",\"amount\":1000,\"cartGoodsUid\":\"78e5c4dc-a79f-42bd-b811-bc3248a57815\",\"stockLimit\":false,\"weight\":0.0,\"tax\":0.01,\"classificationId\":\"\",\"goodsType\":4,\"weightType\":false,\"unit\":\"\",\"originalAmount\":1000,\"subName\":\"大杯\",\"taxId\":\"\",\"qty\":1,\"name\":\"桔子21\",\"materialAmount\":100,\"spuId\":\"187356238010470956\"}]";
        List<CartGoods> cartGoodsList = JSONObject.parseObject(cartGoodsListStr, new TypeReference<List<CartGoods>>() {
        });

        String discountResultStr = "{\"couponDiscounts\":[],\"originalTotalAmount\":1100,\"totalDiscountAmount\":800,\"deliveryAmount\":0,\"distributionFee\":0,\"goods\":[{\"gift\":false,\"smallMaterial\":[{\"realAmount\":27,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"182747638728442153\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":0,\"discount\":73,\"type\":12,\"activityDesc\":\"description\"}],\"originalPrice\":100,\"goodsId\":\"182747638728442153\",\"discountAmount\":73,\"goodsQuantity\":1,\"type\":1}],\"cartGoodsUid\":\"78e5c4dc-a79f-42bd-b811-bc3248a57815\",\"originalPrice\":1000,\"goodsId\":\"187356238100648503\",\"actualGoodsNumber\":1,\"discountAmount\":727,\"meal\":false,\"realAmount\":273,\"nowPrice\":1000,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"goodsId\":\"187356238100648503\",\"activityName\":\"丹妮满减\",\"actualGoodsNumber\":1,\"discount\":727,\"type\":12}],\"goodsQuantity\":1,\"cartGoodType\":0}],\"apportionGoods\":[],\"stocks\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"activityStock\":1,\"activityType\":12,\"goodsStock\":[]}],\"totalAmount\":300,\"discounts\":[{\"activityCode\":\"JTMJ2020092514310052470\",\"thresholdAmount\":1000,\"activityName\":\"丹妮满减\",\"discount\":800,\"type\":12,\"activityDesc\":\"description\"}],\"validCouponMap\":{}}";
        CalculationSharingDiscountResponseDto.CalculationDiscountResult discountResult = JSONObject.parseObject(discountResultStr, new TypeReference<CalculationSharingDiscountResponseDto.CalculationDiscountResult>() {
        });
        /**
         * 用促销价格初始化购物车行记录成交价
         */
        calculationCommonService.initShoppingCart(discountResult, cartGoodsList, shoppingCartGoodsResponseVo);
        /**
         * 利用促销赋值totalDiscountAmount
         */
        List<CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods> goods = discountResult.getGoods();
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> cartGoodsDetailDtoList = new ArrayList<>();
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        shoppingCartGoodsResponseVo.setProducts(cartGoodsList);
        for (CartGoods product : shoppingCartGoodsResponseVo.getProducts()) {
            CalculationSharingDiscountResponseDto.CalculationDiscountResult.Goods find = goods.stream().filter((k) -> k.getCartGoodsUid().equals(product.getCartGoodsUid())).findFirst().get();
            ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = calculationCommonService.convertCartGoods2DetailGoodsList(find, product);
            cartGoodsDetailDtoList.add(cartGoodsDetailDto);
        }
        /**
         * 赠品
         */
        giftSharingService.equally(discountResult, cartGoodsDetailDtoList, null, "saas");
    }

    @Test
    public void product() {
        String productStr = "{\"additionalGroupList\":[],\"barcode\":\"\",\"brandId\":\"\",\"brandName\":\"\",\"businessNo\":\"\",\"businessType\":\"\",\"category\":\"\",\"categoryName\":\"\",\"companyId\":\"2399\",\"completeFlag\":0,\"customerCode\":\"170796389234812474\",\"customerName\":\"\",\"detailImages\":[],\"detailText\":\"\",\"finalPrice\":2,\"isDishware\":0,\"isSkuProduct\":1,\"labelNames\":[],\"maxLimitNumber\":0,\"maxRestrictionQty\":0,\"memberDiscount\":0,\"minLimitNumber\":0,\"minRestrictionQty\":0,\"name\":\"柚子的多规格螃蟹/大杯\",\"openMemberDiscount\":0,\"options\":\"\",\"originalPrice\":2,\"otherDesc\":\"\",\"packPrice\":0,\"picture\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\",\"pid\":\"170796389234812474\",\"pknumber\":0,\"priceSource\":1,\"productAttributeGroupList\":[],\"productBindingCouponTypes\":[],\"productCategoryDetailList\":[],\"productCode\":\"\",\"productComboList\":[],\"productGroupList\":[],\"productPictureList\":[{\"sequence\":0,\"type\":\"default\",\"url\":\"https://img10.sandload.cn/柚子的多规格螃蟹.jpg?timestamp=1594117985325\"}],\"productSpecification\":[],\"productionLocation\":\"\",\"rawMaterial\":\"\",\"remark\":\"\",\"riseSell\":1,\"saleCount\":0,\"salesChannel\":\"\",\"sellTimeList\":[],\"sellTimeMonthList\":[],\"sellTimeRangeList\":[],\"sellTimeValid\":true,\"sequence\":0,\"shopLongTermSalesVolume\":0,\"shopShortTermSalesVolume\":0,\"skuList\":[],\"skuSpecValues\":[{\"productId\":\"170796389234812474\",\"sequence\":2,\"specAttrValues\":[],\"specCustomerCode\":\"hyjbx\",\"specId\":\"170796304154404393\",\"specName\":\"韩月季_杯型\",\"specValue\":\"大杯\",\"specValueCustomerCode\":\"33\",\"specValueId\":\"170796324362561068\"}],\"sourceChannel\":\"\",\"specProductId\":\"\",\"specification\":\"\",\"specificationGroupList\":[],\"specificationList\":[],\"standardGoodsFlag\":0,\"status\":1,\"stock\":9999,\"stockLimit\":2,\"storeCondition\":\"\",\"storeProductName\":\"\",\"tax\":0,\"taxId\":\"\",\"type\":1,\"unit\":\"g\",\"valid\":false,\"version\":0,\"weight\":2,\"weightType\":0}";
        GetProductsVo getProductsVo = JSONObject.parseObject(productStr, new TypeReference<GetProductsVo>() {
        });
        if (null == getProductsVo || !Objects.equals(getProductsVo.getStatus(), StoreItemStatus.PUT_ON_SALE.getCode())) {
            return;
        }
    }
}
